#Homepage.pl
#v1.2
#18/05/03
#Ronnie (ronnie@badpoo.co.uk)
#http://badpoo.co.uk/ronnie/pages/yabbmods.shtml

#.home files have the format
#date last edited (date)|setting for disabling smilies (1 or 0)|banned from using homepage by admin (1 or 0)|hits
#the actual homepage content

sub Homepage
{
	#error for guests
	&fatal_error("$txt{'223'}") if ($username eq 'Guest');

	$hp = "$memberdir/$username.home";
	fopen(FILE, $hp); @lines = <FILE>; fclose(FILE);

	chomp $lines[0];
	($last_modified, $ns, $hp_banned, $hits) = split(/\|/, $lines[0]);
	#are we banned?
	&fatal_error($hp_txt{'13'}) if ($hp_banned);

	#get the size of their homepage
	$hp_size_bytes = -s($hp);
	$hp_size_kilobytes = ($hp_size_bytes > 0 && $hp_size_bytes < 1024) ? 1 : int($hp_size_bytes / 1024);

	#see if we're nearing the limit for file size
	$max_hp_size_bytes = $max_hp_size * 1024;
	$lower_limit = ($max_hp_size_bytes / 10) * 9;
	#we want a warning if above 90% of max. file size
	$filesize_warning = ($hp_size_bytes > $lower_limit) ? qq~<p>$hp_txt{'6'}</p>~ : '';

	#how many words can we fit in the maximum size? (approx.)
	$word_count = int($max_hp_size_bytes / 6);

	#work out which links to show
	$delete_hp_link = ( ! -e($hp) ) ? qq~<li>$hp_txt{'7'}~ : qq~<li><a href="javascript:DoConfirm('$hp_txt{'7'}?','$cgi;action=hpdelete;member=$username')">$hp_txt{'7'}</a>~;
	#and the same for the "view your homepage" link
	$view_hp_link = (! -e($hp) ) ? qq~<li>$hp_txt{'8'}~ : qq~<li><a href="$cgi;action=hpview;member=$username">$hp_txt{'8'}</a>~;

	$yytitle = $hp_txt{'5'};

	#set up the normal page for unrestricted users
	$usual_page = qq~
$filesize_warning

<ul>
<li>$hp_txt{'10'}: $hp_size_kilobytes\Kb ($txt{'576'}. $max_hp_size\Kb).
<li><a href="$cgi;action=hpedit;member=$username">$hp_txt{'9'}</a>
$delete_hp_link
$view_hp_link
$ban_link
</ul>

<ul>
<li><a href="$cgi;action=hplistall">$hp_txt{'11'}</a>
</ul>
~;

	#restricted page - if restricting users is on and this person isn't allowed a page yet
	$restricted_page = qq~<p>$hp_txt{'23'}</p>~;

	#if only certain users are allowed homepages, see if this one is allowed
	#if not, show them the IM link for requesting one
	if ($hp_allowed_users)
	{
		$is_allowed = 0;

		@legit_users = split(/\,/, $hp_allowed_users);
		foreach $legit_user (@legit_users)
		{
			if ($username eq $legit_user) { $is_allowed = 1; last; }
		}

		if ($is_allowed || $settings[7] eq 'Administrator') { $page_output = $usual_page; }
		else { $page_output = $restricted_page; }
	}
	else { $page_output = $usual_page; }

	$yymain .= qq~
<script language="javascript"><!--
function DoConfirm(message, url) { if(confirm(message)) location.href = url; }
// --></script>

<table border="0" width="100%" cellspacing="1" cellpadding="6" bgcolor="$color{'bordercolor'}" class="bordercolor">
<tr>
<td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$yytitle</b></font></td>
</tr><tr>
<td class="windowbg2" bgcolor="$color{'windowbg'}"><font size=2><br>

$page_output

</font></td>
</tr>
</table>
~;

	&template;
	exit;
}



#just show a homepage
sub HomepageView
{
	#error for guests
	&fatal_error($txt{'223'}) if ($username eq 'Guest' && !$guests_view_hp);

	$member = $INFO{'member'} || &fatal_error("$hp_txt{'15'}");
	$hp = "$memberdir/$member.home";

	#check they actually have a homepage
	&fatal_error("$hp_txt{'16'}") unless ( -e($hp) && (-s($hp) > 0) );

	fopen(FILE, $hp); @lines = <FILE>; fclose(FILE);

	chomp $lines[0];
	($last_modified, $ns, $hp_banned, $hits) = split(/\|/, $lines[0]);

	#are we banned?
	&fatal_error($hp_txt{'13'}) if ($hp_banned && $settings[7] ne 'Administrator' && $settings[7] ne 'Global Moderator');

	#is this member allowed to have a page?
	if ($hp_allowed_users)
	{
		$is_allowed = 0;

		@legit_users = split(/\,/, $hp_allowed_users);
		foreach $legit_user (@legit_users)
		{
			if ($member eq $legit_user) { $is_allowed = 1; last; }
		}

		unless ($is_allowed || $settings[7] eq 'Administrator') { &fatal_error($hp_txt{'24'}); }
	}

	#don't increment the count if viewing own page
	if ($member ne $username)
	{
		#add 1 to the hit count
		$hits = int($hits) + 1;
		#create the altered top line
		$lines[0] = qq~$last_modified|$ns|$hp_banned|$hits\n~;
		#write the homepage to file
		fopen(WRITEFILE, ">$hp");
		print WRITEFILE @lines;
		fclose(WRITEFILE);
	}

	#get the last modified date (the first line [0])
	chomp $last_modified; $last_modified = &timeformat($last_modified) || $txt{'470'};

	#now the page itself - starts on the second line [1]
	$num_lines = @lines;
	for ($count = 1; $count < $num_lines; $count++)
	{
		$this_line = $lines[$count];
		chomp $this_line;
		$lines_list .= "$this_line\n";
	}

	#UBBC it?
	if ($enable_ubbc) { require "$sourcedir/YaBBC.pl"; $message = $lines_list; &DoUBBC; $lines_list = $message; }
	else { $lines_list =~ s/\n/<br>/ig; }

	#get the right member info
	#we don't need to load anything if viewing our own page
	if ($member eq $username)
	{
		$membername = $settings[1];
	}
	else
	{
		fopen(FILE, "$memberdir/$member.dat"); @memsettings = <FILE>; fclose(FILE);
		chomp @memsettings;
		$membername = $memsettings[1];
	}

	$yytitle = qq~$hp_txt{'5'} - $hp_txt{'8'} ($membername)~;

	$yymain .= qq~
<script language="javascript"><!--
function DoConfirm(message, url) { if(confirm(message)) location.href = url; }
// --></script>

<table border="0" width="100%" cellspacing="1" cellpadding="6" bgcolor="$color{'bordercolor'}" class="bordercolor">
<tr>
<td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$yytitle</b></font></td>
</tr><tr>
<td class="windowbg" bgcolor="$color{'windowbg'}"><font size=2>$hp_txt{'14'}: $last_modified. $txt{'301'}: $hits.</td>
	~;

	#show the ban/edit/delete page links if viewing own homepage or admin/global moderator
	if ($member eq $username || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator')
	{
		$yymain .= qq~<td class="windowbg" bgcolor="$color{'windowbg'}" align="right"><div align="right">~;

		#admins can do everything except to other admins
		if ($settings[7] eq 'Administrator' && $memsettings[7] ne 'Administrator')
		{
			if ($member ne $username)
			{
				if ($hp_banned) { $yymain .= qq~<a href="$cgi;action=hpban;member=$member">$img{'homepage_unban'}</a>$menusep~; }
				else { $yymain .= qq~<a href="$cgi;action=hpban;member=$member">$img{'homepage_ban'}</a>$menusep~; }
			}

			$yymain .= qq~<a href="$cgi;action=hpedit;member=$member">$img{'modify'}</a>$menusep<a href="javascript:DoConfirm('Delete homepage?','$cgi;action=hpdelete;member=$member')">$img{'delete'}</a>~;
		}
		#allow global moderators to do stuff to homepages as long as they don't belong to admins or other global moderators
		elsif ($settings[7] eq 'Global Moderator' && $memsettings[7] ne 'Administrator' && $memsettings[7] ne 'Global Moderator')
		{
			if ($member ne $username)
			{
				if ($hp_banned) { $yymain .= qq~<a href="$cgi;action=hpban;member=$member">$img{'homepage_unban'}</a>$menusep~; }
				else { $yymain .= qq~<a href="$cgi;action=hpban;member=$member">$img{'homepage_ban'}</a>$menusep~; }
			}
			
			$yymain .= qq~<a href="$cgi;action=hpedit;member=$member">$img{'modify'}</a>$menusep<a href="javascript:DoConfirm('Delete homepage?','$cgi;action=hpdelete;member=$member')">$img{'delete'}</a>~;
		}
		else
		{
			$yymain .= qq~<a href="$cgi;action=hpedit;member=$member">$img{'modify'}</a>$menusep<a href="javascript:DoConfirm('Delete homepage?','$cgi;action=hpdelete;member=$member')">$img{'delete'}</a>~;
		}

		$yymain .= qq~</div></td>~;
	}

	$yymain .= qq~
	</tr>
	<tr><td class="windowbg2" bgcolor="$color{'windowbg'}" colspan="2"><font size=2>
	
$lines_list

</font></td>
</tr>
</table>~;

	&template;
	exit;
}




#edit a page
sub HomepageEdit
{
	#error for guests
	&fatal_error("$txt{'223'}") if ($username eq 'Guest');

	$member = $INFO{'member'} || &fatal_error("$hp_txt{'15'}");

	#for a start, should this member even be on this page?
	&fatal_error("$hp_txt{'12'}") unless ($member eq $username || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator');

	$hp = "$memberdir/$member.home";
	fopen(FILE, $hp); @lines = <FILE>; fclose(FILE);

	chomp $lines[0];
	($last_modified, $ns, $hp_banned, $hits) = split(/\|/, $lines[0]);

	#are we banned?
	&fatal_error($hp_txt{'13'}) if ($hp_banned && $settings[7] ne 'Administrator' && $settings[7] ne 'Global Moderator');

	#is this member allowed to have a page?
	if ($hp_allowed_users)
	{
		$is_allowed = 0;

		@legit_users = split(/\,/, $hp_allowed_users);
		foreach $legit_user (@legit_users)
		{
			if ($member eq $legit_user) { $is_allowed = 1; last; }
		}

		unless ($is_allowed || $settings[7] eq 'Administrator') { &fatal_error($hp_txt{'24'}); }
	}

	#get the last modified date (the first line [0])
	chomp $last_modified; $last_modified = &timeformat($last_modified) || $txt{'470'};
	#check the "disable smilies" box?
	$ns_checked = ($ns eq 'NS') ? ' checked' : '';

	#now the page itself - starts on the second line [1]
	$num_lines = @lines;
	for ($count = 1; $count < $num_lines; $count++)
	{
		$this_line = $lines[$count];
		chomp $this_line;
		$lines_list .= qq~$this_line\n~;
	}

	$lines_list =~ s/\n$//;

	#get the right member info
	#we don't need to load anything if viewing our own page
	if ($member eq $username) { $membername = $settings[1]; }
	else
	{
		fopen(FILE, "$memberdir/$member.dat"); @memsettings = <FILE>; fclose(FILE);
		chomp @memsettings;
		$membername = $memsettings[1];
	}

	$yytitle = qq~$hp_txt{'5'} - $hp_txt{'9'} ($membername)~;

	$yymain .= qq~
<script language="JavaScript1.2" src="$ubbcjspath" type="text/javascript"></script>
<script language="javascript"><!--
function DoConfirm(message, url) { if(confirm(message)) location.href = url; }

function iSubmitOnce(theform)
{
	// if IE 4+ or NS 6+
	if (document.all || document.getElementById)
	{
		// hunt down "submit" and "reset"
		for (i = 0;i < theform.length; i++)
		{
			var tempobj = theform.elements[i];
			if(tempobj.type.toLowerCase() == "submit" || tempobj.type.toLowerCase() == "reset")
				tempobj.disabled = true;
		}
	}
}
// --></script>

<form action="$cgi;action=hpedit2;member=$member" method="POST" onSubmit="iSubmitOnce(this);" name="postmodify">
<input type="hidden" name="hp_banned" value="$hp_banned">
<input type="hidden" name="safety_check" value="1">
<input type="hidden" name="hits" value="$hits">

<table border="0" width="100%" cellspacing="1" cellpadding="6" bgcolor="$color{'bordercolor'}" class="bordercolor">
<tr>
<td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$yytitle</b></font></td>
</tr>

<tr>
<td valign=middle class="windowbg2" bgcolor="$color{'windowbg2'}" colspan=2>

	<table border=0 cellspacing=3 cellpadding=3>
	<tr><td><font size=2>$hp_txt{'14'}: </font></td><td><font size=2>$last_modified</font></td></tr>
	~;
	
	if($enable_ubbc && $showyabbcbutt)
	{
		$yymain .= qq~
	<tr><td valign=top><font size=2>$txt{'252'}: </font></td>
	<td>
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "WebTV Plus Receiver" && navigator.appVersion.charAt(0) >= 3) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          HAND = "onmouseover=this.style.cursor='hand'";
          document.write("<img src='$imagesdir/bold.gif' onclick='bold();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'253'}' border=0>");
          document.write("<img src='$imagesdir/italicize.gif' onclick='italicize();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'254'}' border='0'>");
          document.write("<img src='$imagesdir/underline.gif' onclick='underline();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'255'}' border='0'>");
          document.write("<img src='$imagesdir/strike.gif' onclick='strike();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'441'}' border='0'>");
          document.write("<img src='$imagesdir/glow.gif' onclick='glow();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'442'}' border='0'>");
          document.write("<img src='$imagesdir/shadow.gif' onclick='shadow();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'443'}' border='0'>");
          document.write("<img src='$imagesdir/move.gif' onclick='move();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'439'}' border='0'>");
          document.write("<img src='$imagesdir/pre.gif' onclick='pre();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'444'}' border='0'>");
          document.write("<img src='$imagesdir/left.gif' onclick='left();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'445'}' border='0'>");
          document.write("<img src='$imagesdir/center.gif' onclick='center();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'256'}' border='0'>");
          document.write("<img src='$imagesdir/right.gif' onclick='right();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'446'}' border='0'>");
          document.write("<img src='$imagesdir/hr.gif' onclick='hr();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'531'}' border='0'>");
          document.write("<img src='$imagesdir/size.gif' onclick='size();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'532'}' border='0'>");
          document.write("<img src='$imagesdir/face.gif' onclick='font();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'533'}' border='0'>");
        }
        else { document.write("<font size='1'>$txt{'215'}</font>"); }
        //-->
        </script>
        <noscript>
        <font size="1">$txt{'215'}</font>
        </noscript>
        <select name="color" onChange="showcolor(this.options[this.selectedIndex].value)">
         <option value="Black" selected>$txt{'262'}</option>
         <option value="Red">$txt{'263'}</option>
         <option value="Yellow">$txt{'264'}</option>
         <option value="Pink">$txt{'265'}</option>
         <option value="Green">$txt{'266'}</option>
         <option value="Orange">$txt{'267'}</option>
         <option value="Purple">$txt{'268'}</option>
         <option value="Blue">$txt{'269'}</option>
         <option value="Beige">$txt{'270'}</option>
         <option value="Brown">$txt{'271'}</option>
         <option value="Teal">$txt{'272'}</option>
         <option value="Navy">$txt{'273'}</option>
         <option value="Maroon">$txt{'274'}</option>
         <option value="LimeGreen">$txt{'275'}</option>
        </select><br>
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "WebTV Plus Receiver" && navigator.appVersion.charAt(0) >= 3) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          document.write("<img src='$imagesdir/flash.gif' onclick='flash();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'433'}' border='0'>");
          document.write("<img src='$imagesdir/url.gif' onclick='hyperlink();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'257'}' border='0'>");
          document.write("<img src='$imagesdir/ftp.gif' onclick='ftp();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'434'}' border='0'>");
          document.write("<img src='$imagesdir/img.gif' onclick='image();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'435'}' border='0'>");
          document.write("<img src='$imagesdir/email2.gif' onclick='emai1();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'258'}' border='0'>");
          document.write("<img src='$imagesdir/table.gif' onclick='table();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'436'}' border='0'>");
          document.write("<img src='$imagesdir/tr.gif' onclick='trow();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'437'}' border='0'>");
          document.write("<img src='$imagesdir/td.gif' onclick='tcol();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'449'}' border='0'>");
          document.write("<img src='$imagesdir/sup.gif' onclick='superscript();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'447'}' border='0'>");
          document.write("<img src='$imagesdir/sub.gif' onclick='subscript();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'448'}' border='0'>");
          document.write("<img src='$imagesdir/tele.gif' onclick='teletype();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'440'}' border='0'>");
          document.write("<img src='$imagesdir/code.gif' onclick='showcode();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'259'}' border='0'>");
          document.write("<img src='$imagesdir/quote2.gif' onclick='quote();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'260'}' border='0'>");
          document.write("<img src='$imagesdir/list.gif' onclick='list();' "+HAND+" align=bottom width=23 height=22 alt='$txt{'261'}' border='0'>");
        }
        else { document.write("<font size='1'>$txt{'215'}</font>"); }
        //-->
        </script>
        <noscript>
        <font size="1">$txt{'215'}</font>
        </noscript>
	</td>
	</tr>
~;
}
	$yymain .= qq~
		<tr><td><font size=2>$txt{'297'}: </font></td>
		<td>
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          document.write("<img src='$imagesdir/smiley.gif' onclick='smiley();' "+HAND+" align=bottom alt='$txt{'287'}' border='0'> ");
          document.write("<img src='$imagesdir/wink.gif' onclick='wink();' "+HAND+" align=bottom alt='$txt{'292'}' border='0'> ");
          document.write("<img src='$imagesdir/cheesy.gif' onclick='cheesy();' "+HAND+" align=bottom alt='$txt{'289'}' border='0'> ");
          document.write("<img src='$imagesdir/grin.gif' onclick='grin();' "+HAND+" align=bottom alt='$txt{'293'}' border='0'> ");
          document.write("<img src='$imagesdir/angry.gif' onclick='angry();' "+HAND+" align=bottom alt='$txt{'288'}' border='0'> ");
          document.write("<img src='$imagesdir/sad.gif' onclick='sad();' "+HAND+" align=bottom alt='$txt{'291'}' border='0'> ");
          document.write("<img src='$imagesdir/shocked.gif' onclick='shocked();' "+HAND+" align=bottom alt='$txt{'294'}' border='0'> ");
          document.write("<img src='$imagesdir/cool.gif' onclick='cool();' "+HAND+" align=bottom alt='$txt{'295'}' border='0'> ");
          document.write("<img src='$imagesdir/huh.gif' onclick='huh();' "+HAND+" align=bottom alt='$txt{'296'}' border='0'> ");
          document.write("<img src='$imagesdir/rolleyes.gif' onclick='rolleyes();' "+HAND+" align=bottom alt='$txt{'450'}' border='0'> ");
          document.write("<img src='$imagesdir/tongue.gif' onclick='tongue();' "+HAND+" align=bottom alt='$txt{'451'}' border='0'> ");
          document.write("<img src='$imagesdir/embarassed.gif' onclick='embarassed();' "+HAND+" align=bottom alt='$txt{'526'}' border='0'> ");
          document.write("<img src='$imagesdir/lipsrsealed.gif' onclick='lipsrsealed();' "+HAND+" align=bottom alt='$txt{'527'}' border='0'> ");
          document.write("<img src='$imagesdir/undecided.gif' onclick='undecided();' "+HAND+" align=bottom alt='$txt{'528'}' border='0'> ");
          document.write("<img src='$imagesdir/kiss.gif' onclick='kiss();' "+HAND+" align=bottom alt='$txt{'529'}' border='0'> ");
          document.write("<img src='$imagesdir/cry.gif' onclick='cry();' "+HAND+" align=bottom alt='$txt{'530'}' border='0'> ");
        }
        else { document.write("<font size='1'>$txt{'215'}</font>"); }
        //-->
        </script>
        <noscript>
        <font size="1">$txt{'215'}</font>
        </noscript>
	</td>
	</tr>
	
	<tr>
	<td><font size=2>$txt{'276'}: </font></td>
	<td><input type="checkbox" name="ns" value="NS"$ns_checked></td>
	</tr>
	</table>


</td>
</tr>
	  
<tr><td class="windowbg2" bgcolor="$color{'windowbg'}" colspan=2><font size=2>

<textarea name="message" cols="60" rows="20" wrap="virtual" wrap="soft" style="width:100%" ONCLICK="javascript:storeCaret(this);" ONKEYUP="javascript:storeCaret(this);" ONCHANGE="javascript:storeCaret(this);">$lines_list</textarea><br>
<input type="submit" value="$hp_txt{'9'}">&nbsp;$txt{'377'} <a href="javascript:DoConfirm('$hp_txt{'7'}?','$cgi;action=hpdelete;member=$member')">$hp_txt{'7'}</a>.
</font></td>
</form>
</tr>
</table>
~;

	&template;
	exit;
}




#print the new homepage
sub HomepageEdit2
{
	#error for guests
	&fatal_error($txt{'223'}) if ($username eq 'Guest');
	#stop people accessing this (and wiping .home files) through the URL
	&fatal_error($hp_txt{'12'}) if (!$FORM{'safety_check'});

	$member = $INFO{'member'} || &fatal_error("$hp_txt{'15'}");
	$hp = "$memberdir/$member.home";
	$message = $FORM{'message'};
	$ns = $FORM{'ns'} || 0;
	$hp_banned = $FORM{'hp_banned'} || 0;
	$hits = $FORM{'hits'} || 0;

	#for a start, should this member even be on this page?
	&fatal_error("$hp_txt{'12'}") unless ($member eq $username || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator');

	#a blank homepage
	if ($message eq '')
	{
		unlink("$hp");
		$yySetLocation = qq~$cgi;action=hp~;
		&redirectexit;
	}

	#do we need to trim their homepage?
	if (length($message) > ($max_hp_size * 1024)) { $message = substr($message, 0, ($max_hp_size * 1024)); }

	#ensure proper end of line characters are printed to file
	$message =~ s/\n//g;
	$message =~ s/\r/\n/g;
	#replace < and > to avoid nastiness
	$message =~ s/</&lt;/g;
	$message =~ s/>/&gt;/g;

	#strip all new lines from end of file
	while ($message =~ /\n$/) { $message =~ s/\n$//i; }
	#cut down max. consecutive blank lines to 2
	$message =~ s~\n\n\n\n+~\n\n\n~ig;
	#cut down max. consecutive spaces to 2
	$message =~ s~   +~  ~ig;

	#write the homepage to file
	fopen(WRITEFILE, ">$hp");
	print WRITEFILE "$date\|$ns\|$hp_banned\|$hits\n$message";
	fclose(WRITEFILE);

	$yySetLocation = qq~$cgi;action=hpview;member=$member~;
	&redirectexit;
}



#delete a user.home file
#should get $FORM{'member'} for whose to delete
sub HomepageDelete
{
	$member = $INFO{'member'} || &fatal_error($hp_txt{'15'});

	#for a start, should this member even be on this page?
	&fatal_error($hp_txt{'12'}) unless ($member eq $username || $settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator');

	#delete it
	unlink("$memberdir/$member.home");

	$yySetLocation = qq~$cgi;action=hp~;
	&redirectexit;
}




#list all members with homepages
sub HomepageListAll
{
	#error for guests
	&fatal_error("$txt{'223'}") if ($username eq 'Guest');

	opendir(DIR, "$memberdir") || fatal_error("$txt{'230'}: $memberdir");
	@contents = readdir(DIR);
	closedir(DIR);

	#create an array of members with homepages
	@home_members = ();
	$count = 0;

	foreach $line (@contents)
	{
		@filename_components = split(/\./, $line);
		if ($filename_components[-1] eq 'home')
		{
			#fix the bug with usernames with . in by concatenating all but the last piece of @filename_components
			$joined_name = '';
			$array_length = scalar(@filename_components) - 2;
			for ($i = 0; $i <= $array_length; $i++)
			{
				$joined_name .= $filename_components[$i] . '.';
			}
			$joined_name =~ s/\.$//i;

			#is this member allowed to have a page?
			if ($hp_allowed_users)
			{
				@legit_users = split(/\,/, $hp_allowed_users);
				foreach $legit_user (@legit_users)
				{
					if ($joined_name eq $legit_user) { push(@home_members, $joined_name); $count++; last; }
				}
			}
			else { push(@home_members, $joined_name); $count++; }
		}
	}

	$yytitle = qq~$hp_txt{'5'} - $hp_txt{'11'}~;

	$yymain .= qq~
<table border="0" width="100%" cellspacing="1" cellpadding="6" bgcolor="$color{'bordercolor'}" class="bordercolor">
<tr>
<td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$yytitle</b></font></td>
</tr><tr>
<td class="windowbg2" bgcolor="$color{'windowbg'}"><font size=2><br>
~;

	if ($count == 0)
	{
		$yymain .= qq~<p>$hp_txt{'17'}</p>~;
	}
	else
	{
		$yymain .= qq~
		<table border="0" cellspacing="1" cellpadding="5" bgcolor="$color{'bordercolor'}" class="bordercolor">
		<tr>
		<td class="catbg">&nbsp;</td><td class="catbg"><font size="2">$txt{'301'}</font></td><td class="catbg"><font size="2">$hp_txt{'14'}</font></td>~;
		if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') { $yymain .= qq~<td class="catbg"><font size="2">$hp_txt{'2'}</font></td>~; }
		$yymain .= qq~</tr>~;

		#list the members
		foreach $member (@home_members)
		{
			#get their name
			fopen(FILE, "$memberdir/$member.dat"); @memsettings=<FILE>; fclose(FILE);
			chomp $memsettings[1];

			#don't show them in the list to normal users if they're banned
			#do show them with a "banned" message to admins/global moderators
			$hp = "$memberdir/$member.home";
			fopen(FILE, $hp); @lines = <FILE>; fclose(FILE);

			chomp $lines[0];
			($last_modified, $ns, $hp_banned, $hits) = split(/\|/, $lines[0]);

			$last_modified = &timeformat($last_modified) || $last_modified;

			if ($hp_banned)
			{
				#only show a banned homepage if admin/global moderator
				if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator')
				{
					$yymain .= qq~<tr><td class="windowbg2"><font size="2"><a href="$cgi;action=hpview;member=$member">$memsettings[1]</a></font></td>~;
					$yymain .= qq~<td class="windowbg2"><font size="2">$hits</font></td>\n~;
					$yymain .= qq~<td class="windowbg2"><font size="2">$last_modified</font></td>\n~;
					$yymain .= qq~<td class="windowbg2"><font size="2"><a href="$cgi;action=hpban;member=$member">$img{'homepage_unban'}</a></font></td>\n</tr>~;
				}
			}
			else
			{
					$yymain .= qq~<tr><td class="windowbg2"><font size="2"><a href="$cgi;action=hpview;member=$member">$memsettings[1]</a></font></td>~;
					$yymain .= qq~<td class="windowbg2"><font size="2">$hits</font></td>\n~;
					$yymain .= qq~<td class="windowbg2"><font size="2">$last_modified</font></td>\n~;
					if ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator') { $yymain .= qq~<td class="windowbg2">&nbsp;</td>~; }
					$yymain .= qq~</tr>~;
			}
		}

		$yymain .= qq~</table>\n~;
	}

	$yymain .= qq~

<br></font></td>
</tr>
</table>~;

	&template;
	exit;
}

#ban or unban a member from using their homepage
#decides by switching whatever the current ban setting is
sub HomepageBan
{
	$member = $INFO{'member'} || &fatal_error("$hp_txt{'15'}");

	#error for guests
	&fatal_error("$txt{'223'}") if ($username eq 'Guest');
	#for a start, should this member even be on this page?
	&fatal_error("$hp_txt{'12'}") unless ($settings[7] eq 'Administrator' || $settings[7] eq 'Global Moderator');

	$hp = "$memberdir/$member.home";
	fopen(FILE, $hp); @lines = <FILE>; fclose(FILE);

	chomp $lines[0];
	($last_modified, $ns, $hp_banned, $hits) = split(/\|/, $lines[0]);

	#switch the ban setting
	$hp_banned = ($hp_banned) ? 0 : 1;

	#create the altered top line
	$lines[0] = qq~$last_modified|$ns|$hp_banned|$hits\n~;

	#write the homepage to file
	fopen(WRITEFILE, ">$hp");
	print WRITEFILE @lines;
	fclose(WRITEFILE);

	$yySetLocation = qq~$cgi;action=hpview;member=$member~;
	&redirectexit;
}

1;