###############################################################################
# Attachments.pl							      #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Project started by Zef Hemel (zef@zefnet.com)                   #
# Software Version: YaBB 1 Gold - Release                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2001 X-Null - All Rights Reserved                        #
# Software by: The YaBB Development Team                                      #
###############################################################################

sub Attachments {
	&is_admin;
	my (@attachments, $remaining_space, $totalattachnum, $spaceleft, $fsize);
	fopen(AMS, "$vardir/attachments.txt");
	@attachments = <AMS>;
	fclose(AMS);
	$totalattachnum = @attachments;
	foreach $line(@attachments) {
		chomp $line;
		my($dummy, $dummy, $dummy, $dummy, $dummy, $fsize, $dummy, $dummy) = split(/\|/, $line);
		$attachment_space += $fsize;
	}
	if(!$attachment_space) { $attachment_space = 0; }
	if ($dirlimit != 0) {
		$spaceleft = ($dirlimit - $attachment_space);
		$remaining_space = "$spaceleft $fatxt{'21c'}";
	} else {
		$remaining_space = "$fatxt{'23'}";
	}
	fopen(FILE, "$vardir/oldestattach.txt");
	$maxdaysattach = <FILE>;
	fclose(FILE);
	fopen(FILE, "$vardir/maxattachsize.txt");
	$maxsizeattach = <FILE>;
	fclose(FILE);
$yymain .= qq~
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
<tr>
<td class="titlebg" bgcolor="$color{'titlebg'}">
<img src="$imagesdir/xx.gif" alt="">
<font size=2 class="text1" color="$color{'titletext'}"><b>$fatxt{'24'}</b></font></td>
</tr><tr>
<td class="windowbg" bgcolor="$color{'windowbg'}"><br /><font size="1">$fatxt{'25'}</font><br /><br /></td>
</tr><tr>
<td width="460" class="catbg" bgcolor="$color{'catbg'}"><font size="2"><b>$fatxt{'26'}<b></font></td>
</tr><tr>
<td bgcolor="$color{'windowbg'}" class="windowbg" height="21">
<font size="2"><b>$fatxt{'27'}</b></font><br /></td>
</tr><tr>
<td bgcolor="$color{'windowbg2'}" class="windowbg2">
<table border="0" cellpadding="3" cellspacing="0"><tr>
<td><font size="2"><b>$fatxt{'28'}</b></font></td>
<td><font size="1">$totalattachnum</font></td>
</tr><tr>
<td><font size="2"><b>$fatxt{'29'}</b></font></td>
<td><font size="1">$attachment_space $fatxt{'21c'}</font><br /></td>
</tr><tr>
<td><font size="2"><b>$fatxt{'30'}</b></font></td>
<td><font size="1">$remaining_space</font></td>
</tr>
</table><br />
</td>
</tr><tr>
<td bgcolor="$color{'windowbg'}" class="windowbg" height="21">
<font size="2"><b>$fatxt{'31'}</b></font><br /></td>
</tr><tr>
<td bgcolor="$color{'windowbg2'}" class="windowbg2">
<table border="0" cellpadding="3" cellspacing="0">
<tr>
<td><font size="2"><a href="$cgi;action=manageattachments2"><font size="2">$fatxt{'31a'}</font></a></td>
<td></td>
</tr><tr>
<form action="$cgi;action=removeoldattachments" method="post">
<td><font size="2">$fatxt{'32'} <input type=text name="maxdaysattach" size="2" value="$maxdaysattach"> $txt{'122'}&nbsp;</td>
<td><input type=submit value="$txt{'31'}"></td>
</form>
</tr><tr>
<form action="$cgi;action=removebigattachments" method="post">
<td><font size="2">$fatxt{'33'} <input type=text name="maxsizeattach" size="2" value="$maxsizeattach"> $fatxt{'21c'}&nbsp;</td>
<td><input type=submit value="$txt{'31'}"></td>
</form>
</tr>
</table>
</td>
</tr>
</table>
~;
	$yytitle = "$fatxt{'36'}";
	&template;
	exit;
}

sub RemoveOldAttachments {
	&is_admin;
	fopen(FILE, ">$vardir/oldestattach.txt");
	print FILE "$FORM{'maxdaysattach'}";
	fclose(FILE);
	$date2 = $date;
	fopen(FILE, "$vardir/attachments.txt");
	@attachments = <FILE>;
	fclose(FILE);
	if (1 > @attachments) {
		$yymain .= qq~<font size="2"><center><b><i>$fatxt{'48'}</i></b></center>~;
	} else {
		fopen(FILE, ">$vardir/attachments.txt");
		for ($a = 0; $a < @attachments; $a++) {
			my ($dummy, $dummy, $dummy, $dummy, $dummy, $dummy, $tmpdate, $fn) = split(/\|/,$attachments[$a]);
			chomp $fn;
			$date1 = $tmpdate;
			&calcdifference;
			if($result <= $FORM{'maxdaysattach'}) {
				# If the attachment is not too old
				print FILE $attachments[$a];
				$yymain .= qq~ $fn = $result $txt{'122'}<br /> ~;
			} else {
				$yymain .= qq~ $fn = $result $txt{'122'} ($txt{'123'})<br /> ~;
				if(-e("$upload_dir/$fn")) {
					unlink("$upload_dir/$fn");
				}
			}
		}
	}
	fclose(FILE);
	$yytitle = "$fatxt{'34'} $FORM{'maxdaysattach'}";
	&template;
	exit;
}

sub RemoveBigAttachments {
	&is_admin;
	fopen(FILE, ">$vardir/maxattachsize.txt");
	print FILE "$FORM{'maxsizeattach'}";
	fclose(FILE);
	fopen(FILE, "$vardir/attachments.txt");
	@attachments = <FILE>;
	fclose(FILE);
	fopen(FILE, ">$vardir/attachments.txt");
	if (1 > @attachments) {
		$yymain .= qq~<font size="2"><center><b><i>$fatxt{'48'}</i></b></center>~;
	} else {
		for ($a = 0; $a < @attachments; $a++) {
			my ($dummy, $dummy, $dummy, $dummy, $dummy, $size, $dummy, $fn) = split(/\|/,$attachments[$a]);
			chomp $fn;
			if($size <= $FORM{'maxsizeattach'}) {
				# If the attachment is not too big
				print FILE $attachments[$a];
				$yymain .= qq~ $fn = $size $fatxt{'21c'}<br /> ~;
			} else {
				$yymain .= qq~ $fn = $size $fatxt{'21c'} ($txt{'123'})<br /> ~;
				if(-e("$upload_dir/$fn")) {
					unlink("$upload_dir/$fn");
				}	
			}
		}
	}
	fclose(FILE);
	$yytitle = "$fatxt{'35'} $FORM{'maxsizeattach'} $fatxt{'21c'}";
	&template;
	exit;
}

sub ViewAttachments {
	&is_admin;
	fopen(ATTDB, "$vardir/attachments.txt");
	my @attachments = <ATTDB>;
	fclose(ATTDB);
	if (1 > @attachments) {
		$viewattachments .= qq~
		<tr>
			<td bgcolor="$color{'windowbg2'}" colspan="6"><font size="2"><center><b><i>$fatxt{'48'}</i></b></center></font></td>
		</tr>~;
	} else {
		foreach $row (@attachments) {
		chomp $row;
		my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/,$row);
		if (length($amthreadsub) > 20) { $amthreadsub = substr($amthreadsub,0,20)."..."; }
		$viewattachments .= qq~
		<tr>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><font size="2"><a href="$http_dir/$amfn" target="blank"> $amfn</a></td>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><font size="2">$amkb $fatxt{'21c'}</td>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><font size="2">$amposter</td>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><font size="2">$amdate</td>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><a href="$scripturl?board=$amcurrentboard;action=display;num=$amthreadid;start=$amreplies" target="blank"><font size="2">$amthreadsub</a></td>
			<td bgcolor="$color{'windowbg2'}" align="left" valign="middle"><a href="$scripturl?board=$board;action=deleteattachment;attachment=$amfn"><font size="2">$fatxt{'45'}</a></td>
		</tr>\n~;
		}
	}
$yymain .= qq~
<script language="javascript">
<!-- //
function confirm_deleteall (resource)   {
	if (window.confirm(resource) )  {
		window.location.href =  "$scripturl?board=$board;action=deleteattachment;attachment=all";
		}
	}
// -->
</script>
<table border="0" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center" width="100%">
<tr>
<td bgcolor="$color{'titlebg'}" class="titlebg">
<img src="$imagesdir/xx.gif" alt="" border="0">&nbsp;
<font size="2" class="text1" color="$color{'titletext'}"><b>$yytitle</b></font></td>
</tr><tr>
<td bgcolor="$color{'windowbg'}" class="windowbg">
<font size="1"><br />
$fatxt{'38'}
<br /><br />
</td>
</tr><tr>
<td bgcolor="$color{'catbg'}" class="catbg">
<font size="2"><center><b>$fatxt{'39'}</b></center></font>
</td>
</tr><tr>
<td bgcolor="$color{'windowbg2'}"><font size="2">
<br /><center><table border="0" cellpadding="2" cellspacing="1" bgcolor="$color{'bordercolor'}" width="75%">
<tr><td colspan="6" align="center" bgcolor="$color{'titlebg'}" width="100%"><font size="2" class="text1" color="$color{'titletext'}"><b>$fatxt{'31b'}</b></font></td></tr>
<tr><td bgcolor="$color{'catbg'}" width="25%"><font size="2"><b> $fatxt{'40'}</b></font></td><td bgcolor="$color{'catbg'}" width="10%"><font size="2"><b> $fatxt{'41'}</b></font></td><td bgcolor="$color{'catbg'}" width="10%"><font size="2"><b> $fatxt{'42'}</b></font></td><td bgcolor="$color{'catbg'}" width="20%"><font size="2"><b> $fatxt{'43'}</b></font></td><td bgcolor="$color{'catbg'}" width="25%"><font size="2"><b> $fatxt{'44'}</b></font></td><td bgcolor="$color{'catbg'}" width="10%"><font size="2"><b> $fatxt{'45'}</b></font></td></tr>
$viewattachments
</table>
~;
unless (1 > @attachments) {
$yymain .= qq~
<table border="0" cellpadding="2" cellspacing="1" width="75%">
<tr><td align="right" valign="middle" border="0"><font size="2"><a href='javascript:confirm_deleteall( "$fatxt{'46'}" );'>$fatxt{'45a'}</a></td></tr>
</table>
~;
}
$yymain .= qq~
<br /></center>
</font></td></tr></table>
~;
	$yytitle = "$fatxt{'37'}";
	&template;
	exit;
}

sub DeleteAttachments {
	&is_admin;
	my $attachment = $INFO{'attachment'};
	if ($attachment eq "all") {
		&do_attach("flush",$attachment);
		$yySetLocation = qq~$cgi;action=manageattachments2~;
		&redirectexit;
	} else {
		&do_attach("remove",$attachment);
		$yySetLocation = qq~$cgi;action=manageattachments2~;
		&redirectexit;
	}
}

1;