###############################################################################
# ExtendedProfiles.pl - v1.2.4                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 1 Gold - SP 1.4                                        #
# Released:       December 2001; Updated November 25, 2004                    #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2003 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
###############################################################################
# This file is part of the Extended Profiles Mod which has been created by    #
# Michael Prager. Last modification: 25.04.04                                 #
###############################################################################
# file formats used by this code:
#
#  username.ext - contains the additional user profile information. Uses line number as id
#  ------------
#  value
#  value
#  value
#  ...
#
#  extended_profiles_order.txt - contains the order in which the fields will be displayed
#  ---------------------------
#  name
#  name
#  name
#  ...
#
#  extended_profiles_fields.txt - defines the new profile fields. Uses line number as id
#  ----------------------------
#  name|type|options|active|comment|required_on_reg|visible_in_viewprofile|v_users|v_groups|visible_in_posts|p_users|p_groups|p_displayfieldname|visible_in_memberlist|m_users|m_groups|editable_by_user
#  name|type|options|active|comment|required_on_reg|visible_in_viewprofile|v_users|v_groups|visible_in_posts|p_users|p_groups|p_displayfieldname|visible_in_memberlist|m_users|m_groups|editable_by_user
#  name|type|options|active|comment|required_on_reg|visible_in_viewprofile|v_users|v_groups|visible_in_posts|p_users|p_groups|p_displayfieldname|visible_in_memberlist|m_users|m_groups|editable_by_user
#  ...
#
#  Here are all types with their possible type-specific options. If options contain multiple entries, seperated by ^
#  - text		limit_len^width^is_numberic^default_value^allow_ubbc
#  - text_multi		limit_len^rows^cols^allow_ubbc
#  - select		option1^option2^option3... (first option is default)
#  - radiobuttons	option1^option2^option3... (first option is default)
#  - spacer		br_or_hr^visible_in_editprofile
#  - checkbox		-
#  - date		-
#  - emial		-
#  - url		-
#
#  required_on_reg can have value 0 (disabled), 1 (required on registration) and 2 (not req. but display on reg. page anyway)
#
# NOTE: use prefix "ext_" in sub-, variable- and formnames to prevent conflicts with other mods
#
# easy mod integration: use ext_get($username,"fieldname") go get user's field value
#
###############################################################################

# Language Definitions:
$lang_ext{'true'} = "yes";
$lang_ext{'false'} = "no";
$lang_ext{'max_chars1'} = "Max ";
$lang_ext{'max_chars2'} = "; characters remaining: ";
$lang_ext{'field_not_existing1'} = "Field ";
$lang_ext{'field_not_existing2'} = " does not exist";
$lang_ext{'not_allowed_to_modify'} = "You are not allowed to modify this field";
$lang_ext{'invalid_char'} = "Invalid character used";
$lang_ext{'too_long'} = "Value is too long";
$lang_ext{'not_numeric'} = "Value is not numeric";
$lang_ext{'too_small'} = "Value is too small";
$lang_ext{'too_big'} = "Value is too big";
$lang_ext{'option_does_not_exist'} = "Option does not exist";
$lang_ext{'invalid_year'} = "Invalid year format. Please use YYYY";
$lang_ext{'required'} = "This field is required!";
$lang_ext{'cannot_write_file'} = "Can't write file ";
$lang_ext{'Profiles_Controls'} = "Extended Profiles";
$lang_ext{'admin_field'} = "Edit Profile Fields (create/edit/reorder)";
$lang_ext{'edit_title'} = "Edit Existing Profile Fields";
$lang_ext{'edit_existing_fields'} = "edit existing fields";
$lang_ext{'reorder fields'} = "reorder fields";
$lang_ext{'reorder_title'} = "Reorder Profile Fields";
$lang_ext{'create_new_title'} = "Create New Profile Field";
$lang_ext{'admin_description'} = "Welcome to the Extended Profiles Administration Controls. Here you can add, modify, remove and reorder additional profile fields for your members. But before you start, you should know a couple of things:<br><br>Before you start adding fields wildly, make sure to think about what fields you really want/need. Try to avoid late and big changes because your members may have to modify their profiles according to these changes everytime they are made. Also note that as more fields you add, as bigger your profiles will be. This mod will try to minimize the disk usage by deleting profile information which is equal to the default values.<br><br>Finally make sure your board is in <b>maintenance mode</b> before adding or deleting fields to avoid users who change their profile while changes are made.";
$lang_ext{'create_new_description'} = "Here you can create new profile fields. Before you create a field, be sure which type you want. Although it is possible to change the type afterwards, it is not recommented. After you created a new field, make sure to goto the options screen for more advanced settings. The field name can be choosen freely, there are no limitations. You can even use html.<br><br>Using the 'Create Profile' button may take some time since it has to go through all profile files.";
$lang_ext{'edit_description'} = "Apply modifications to existing profile fields here. You can change the active state and the name without much concern. But <b>before you modify the field type</b>, you should know the following: <br><br>Changing the fieldtype from radiobuttons to dropdown lists and the other way around is no problem. However if you for example turn a radiobutton field to textbox, you should concern this modifcation does not affect the data which users may already have entered in their profiles. So if a user has choosen the first option and you turn it into a textbox, he will have a 0 in this field until he changes his profile.<br>To clear whatever the user had in this field, you should rather delete the whole field and than add a new one. That's the only way to clear a specific field's content.<br>Also make sure to change the options of this field since different types may have different options available.<br><br>Using the 'Delete' button may take some time since it has to go through all profile files.";
$lang_ext{'no_additional_fields_set'} = "no additional fields set";
$lang_ext{'active'} = "Active";
$lang_ext{'field_name'} = "Field Name";
$lang_ext{'field_type'} = "Field Type";
$lang_ext{'actions'} = "Actions";
$lang_ext{'text'} = "Textbox (single line)";
$lang_ext{'text_multi'} = "Textarea (multiple lines)";
$lang_ext{'select'} = "Dropdown List (single selection)";
$lang_ext{'radiobuttons'} = "Radiobuttons";
$lang_ext{'checkbox'} = "Checkbox";
$lang_ext{'date'} = "Date";
$lang_ext{'email'} = "Email";
$lang_ext{'url'} = "Url";
$lang_ext{'spacer'} = "Spacer";
$lang_ext{'apply'} = "Apply";
$lang_ext{'options'} = "Options";
$lang_ext{'delete'} = "Delete";
$lang_ext{'create_field'} = "Create Field";
$lang_ext{'reorder_description'} = "Reorder the fields by copy & past the fieldnames in the box on the left. When you're done, hit the 'Reorder' button below.";
$lang_ext{'reorder'} = "Reorder";
$lang_ext{'fields_reordered'} = "Profile fields have been reordered.";
$lang_ext{'go_back'} = "Go back";
$lang_ext{'to'} = "to";
$lang_ext{'field_created'} = "Profile field has been created.";
$lang_ext{'field_changed'} = "Profile field has been changed.";
$lang_ext{'options_title'} = "Field Options";
$lang_ext{'options_description'} = "Change field settings here. Note that some settings may be type-dependend and only available for some fields.";
$lang_ext{'change_these_settings'} = "change these settings";
$lang_ext{'comment'} = "Comment";
$lang_ext{'comment_description'} = "This will be displayed on the edit profile page under the field name. You can use html here.";
$lang_ext{'Save'} = "Save";
$lang_ext{'required_on_reg'} = "Required On Registration";
$lang_ext{'required_on_reg_description'} = "If you make this field required, it will be shown on registration page. If set to 'optional', it will only be displayed on edit profile page.";
$lang_ext{'req0'} = "optional";
$lang_ext{'req1'} = "required";
$lang_ext{'req2'} = "not required but show on registration anyway";
$lang_ext{'visible_in_viewprofile'} = "Visible In ViewProfile";
$lang_ext{'visible_in_viewprofile_description'} = "Check if you want this field to be displayed on the viewprofile page. You can limit it to certain users and/or groups by entering names in the fields on the right. Seperate by comma if you have multiple. Example: username1,username2. Leave the fields empty if you want the information to be visible for all.";
$lang_ext{'v_users'} = "limit to users";
$lang_ext{'v_groups'} = "limit to groups";
$lang_ext{'visible_in_posts'} = "Visible In Posts";
$lang_ext{'visible_in_posts_description'} = "Check if you want this field to be displayed in post view, right under the author information. You can limit it to certain users and/or groups by entering names in the fields on the right. Seperate by comma if you have multiple. Example: username1,username2. Leave the fields empty if you want the information to be visible for all.";
$lang_ext{'p_users'} = "limit to users";
$lang_ext{'p_groups'} = "limit to groups";
$lang_ext{'display_fieldname'} = "display fieldname";
$lang_ext{'visible_in_memberlist'} = "Visible In Memberlist";
$lang_ext{'visible_in_memberlist_description'} = "Check if you want this field to be displayed in the memberlist. You can limit it to certain users and/or groups by entering names in the fields on the right. Seperate by comma if you have multiple. Example: username1,username2. Leave the fields empty if you want the information to be visible for all.";
$lang_ext{'m_users'} = "limit to users";
$lang_ext{'m_groups'} = "limit to groups";
$lang_ext{'editable_by_user'} = "Editable By User";
$lang_ext{'editable_by_user_description'} = "If you disable this, only admins will be able to change this setting. It will become invisible for the user in editprofile.";
$lang_ext{'limit_len'} = "Limit Length";
$lang_ext{'limit_len_description'} = "Limits the maximum amount of characters. Set to 0 or leave empty to disable the limit. <b>Warning</b>: It is recommented to set a limit. Anything else can cause VERY big profile files.";
$lang_ext{'width'} = "Display Width";
$lang_ext{'width_description'} = "This controls the 'width' setting of the input box. Leave empty to use the browser's default value.";
$lang_ext{'is_numeric'} = "Value Must Be Numeric";
$lang_ext{'is_numeric_description'} = "Use this to force people to enter a numeric value";
$lang_ext{'default'} = "Default Value";
$lang_ext{'default_description'} = "This value will be set if the user didn't fill out this field. Leave empty to disable default values for this field.";
$lang_ext{'ubbc'} = "Allow UBBC";
$lang_ext{'ubbc_description'} = "Enables UBBC code for this field. <b>Warning:</b> this means full access to all tags!";
$lang_ext{'rows'} = "Rows";
$lang_ext{'rows_description'} = "This controls the 'rows' setting of the textarea box. Leave empty to use the browser's default value.";
$lang_ext{'cols'} = "Cols";
$lang_ext{'cols_description'} = "This controls the 'cols' setting of the textarea box. Leave empty to use the browser's default value.";
$lang_ext{'s_options'} = "Options";
$lang_ext{'s_options_description'} = "These will be the selectable options. Write one option per line. The first options will be default. You can use html here.";
$lang_ext{'visible_in_editprofile'} = "Visible In EditProfile";
$lang_ext{'visible_in_editprofile_description'} = "Should the spacer be visible in editprofile?";
$lang_ext{'hr_or_br'} = "Spacer Type";
$lang_ext{'hr_or_br_description'} = "Select if the spacer should be displayed as &lt;hr&gt; or &lt;br&gt;";
$lang_ext{'hr'} = "&lt;hr&gt;";
$lang_ext{'br'} = "&lt;br&gt;";
###############################################################################

# outputs the value of a user's extended profile field
sub ext_get {
	my ($pusername, $fieldname, @ext_profile, $output, @options, $field, $id) = (shift, shift);
	@ext_profile = ext_get_profile($pusername);
	$id = ext_get_field_id($fieldname);
	$field = ext_get_field($id);
	if ($field{'type'} eq "select" || $field{'type'} eq "radiobuttons") {
		@options = split(/\^/,$field{'options'});
		$output = $options[$ext_profile[$id]];
	} else {
		$output = $ext_profile[$id];
	}
	return $output;
}

# returns the extended profile of a user
sub ext_get_profile {
	my ($pusername, @ext_profile) = (shift);
	if (-e "$memberdir/$pusername.ext") {
		fopen(FILE, "$memberdir/$pusername.ext");
		@ext_profile = <FILE>;
		fclose(FILE);
		chomp @ext_profile;
	}
	return @ext_profile;
}

# returns all available profile fields
sub ext_get_fields {
	# only load from file if not already loaded to speed things up
	if (!defined @ext_fields) {
		fopen(FILE, "$vardir/extended_profiles_fields.txt") || &fatal_error("$txt{'23'} extended_profiles_fields.txt");
		@ext_fields = <FILE>;
		fclose(FILE);
		chomp @ext_fields;
	}
	return @ext_fields;
}

# returns a list of all profile fields, in proper order
sub ext_get_field_order {
	# only load from file if not already loaded to speed things up
	if (!defined @ext_field_order) {
		fopen(FILE, "$vardir/extended_profiles_order.txt") || &fatal_error("$txt{'23'} extended_profiles_order.txt");
		@ext_field_order = <FILE>;
		fclose(FILE);
		chomp @ext_field_order;
	}
	return @ext_field_order;
}

# returns the id of a field through the fieldname
sub ext_get_field_id {
	my ($fieldname, $count, $id, $current, $currentname, $dummy) = (shift, 0);
	foreach $current (ext_get_fields) {
		($currentname, $dummy) = split(/\|/, $current);
		if ($currentname eq $fieldname) { $id = $count; last; }
		$count++;
	}
	return $id;
}

# returns all settings of a specifig field
sub ext_get_field {
	my ($id, $field, @fields, $dummy) = (shift);
	@fields = ext_get_fields;
	$field{'id'} = $id;
	($field{'name'},
	$field{'type'},
	$field{'options'},
	$field{'active'},
	$field{'comment'},
	$field{'required_on_reg'},
	$field{'visible_in_viewprofile'},
	$field{'v_users'},
	$field{'v_groups'},
	$field{'visible_in_posts'},
	$field{'p_users'},
	$field{'p_groups'},
	$field{'p_displayfieldname'},
	$field{'visible_in_memberlist'},
	$field{'m_users'},
	$field{'m_groups'},
	$field{'editable_by_user'},
	$dummy) = split(/\|/,$fields[$field{'id'}]);
	return $field;
}

# formats a MM/DD/YYYY string to the user's prefered format
sub ext_timeformat {
	if ($settings[17] > 0) { $mytimeselected = $settings[17]; } else { $mytimeselected = $timeselected; }

	$oldformat = shift;
	if( $oldformat eq '' || $oldformat eq "\n" ) { return $oldformat; }

	$oldmonth = substr($oldformat,0,2);
	$oldday = substr($oldformat,3,2);
	$oldyear = substr($oldformat,6,4);

	if ($oldformat ne '') {
		$newday = $oldday+0;
		$newmonth = $oldmonth+0;
		$newyear = $oldyear+0;
		$newshortyear = substr($newyear,2,2);
		if ($newmonth < 10) { $newmonth = "0$newmonth"; }
		if ($newday < 10 && $mytimeselected != 4) { $newday = "0$newday"; }

		if ($mytimeselected == 1) {
			$newformat = qq~$newmonth/$newday/$newshortyear~;
			return $newformat;

		} elsif ($mytimeselected == 2) {
			$newformat = qq~$newday.$newmonth.$newshortyear~;
			return $newformat;

		} elsif ($mytimeselected == 3) {
			$newformat = qq~$newday.$newmonth.$newyear~;
			return $newformat;

		} elsif ($mytimeselected == 4) {
			$newmonth--;
			$newmonth2 = $months[$newmonth];
			if( $newday > 10 && $newday < 20 ) { $newday2 = '<sup>th</sup>'; }
			elsif( $newday % 10 == 1 ) { $newday2 = '<sup>st</sup>'; }
			elsif( $newday % 10 == 2 ) { $newday2 = '<sup>nd</sup>'; }
			elsif( $newday % 10 == 3 ) { $newday2 = '<sup>rd</sup>'; }
			else{ $newday2 = '<sup>th</sup>'; }
			$newformat = qq~$newmonth2 $newday$newday2, $newyear~;
			return $newformat;

		} elsif ($mytimeselected == 5) {
			$newformat = qq~$newmonth/$newday/$newshortyear~;
			return $newformat;

		} elsif ($mytimeselected == 6) {
			$newmonth2 = $months[$newmonth-1];
			$newformat = qq~$newday. $newmonth2 $newyear~;
			return $newformat;
		}
	} else { return ''; }
}

# returns whenever the current user is allowed to view a field or not
sub ext_has_access {
	my ($allowed_users, $allowed_groups, $access, $usergroup, $user, @users, $group, @groups) = (shift, shift, 0, $settings[7]);
	if (($allowed_users ne "") || ($allowed_groups ne "")) {
		if ($allowed_users ne "") {
			@users = split(/\,/,$allowed_users);
			foreach $user (@users) {
				if ($user eq $username) { $access = 1; last; }
			}
		}
		if ($allowed_groups ne "") {
			@groups = split(/\,/,$allowed_groups);
			foreach $group (@groups) {
				if ($group eq $usergroup) { $access = 1; last; }
			}
		}
	} else { $access = 1; }
	return $access;
}

# applies UBBC code to a string
sub ext_parse_ubbc {
	my ($source, $pusername, $bak, $bak2) = (shift, shift, $message, $displayname);
	$message = $source;
	require "$sourcedir/YaBBC.pl";
	$displayname = $pusername; # must be set for /me tag
	&DoUBBC;
	$source = $message;
	$message = $bak;
	$displayname = $bak2;
	return $source;
}

# returns the output for the viewprofile page
sub ext_viewprofile {
	my ($pusername, @ext_profile, $field, $id, $output, $fieldname, @options) = (shift);
	@ext_profile = ext_get_profile($pusername);

	foreach $fieldname (ext_get_field_order) {
		$id = ext_get_field_id($fieldname);
		$field = ext_get_field($id);

		# make sure the field is visible and the user allowed to view the current field
		if (($field{'visible_in_viewprofile'} == 1) &&
		   ($field{'active'} == 1) &&
		   (ext_has_access($field{'v_users'},$field{'v_groups'}) == 1)) {
			if ($output eq "") { $output = qq~<tr><td colspan="2"><hr size="1" width="100%" class="hr"></td></tr><tr>\n~; }
			# format the output dependend of the field type
			if ($field{'type'} eq "text") {
				@options = split(/\^/,$field{'options'});
				if ($options[3] ne "" && $ext_profile[$id] eq "") { $ext_profile[$id] = $options[3]; }
				if ($options[4] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "text_multi") {
				@options = split(/\^/,$field{'options'});
				if ($options[3] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "select") {
				@options = split(/\^/,$field{'options'});
				if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
				$ext_profile[$id] = $options[$ext_profile[$id]];
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "radiobuttons") {
				@options = split(/\^/,$field{'options'});
				if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
				$ext_profile[$id] = $options[$ext_profile[$id]];
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "date") {
				$ext_profile[$id] = ext_timeformat($ext_profile[$id]);
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "checkbox") {
				if ($ext_profile[$id] == 1) { $ext_profile[$id] = $lang_ext{'true'} } else { $ext_profile[$id] = $lang_ext{'false'} }
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "spacer") {
				@options = split(/\^/,$field{'options'});
				if ($options[0] == 1) { $output .= qq~<td colspan="2"><br></td></tr><tr>\n~; }
				else { $output .= qq~<td colspan="2"><hr size="1" width="100%" class="hr"></td></tr><tr>\n~; }
			}
			elsif ($field{'type'} eq "email") {
				if ($ext_profile[$id] ne "") { $ext_profile[$id] = qq~<a href="mailto:$ext_profile[$id]">$ext_profile[$id]</a>~; }
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
			elsif ($field{'type'} eq "url") {
				if ($ext_profile[$id] !~ m~\Ahttp://~ && $ext_profile[$id] ne "") { $ext_profile[$id] = "http://$ext_profile[$id]"; }
				if ($ext_profile[$id] ne "") { $ext_profile[$id] = qq~<a href="$ext_profile[$id]" target="_blank">$ext_profile[$id]</a>~; }
				$output .= qq~<td valign="top"><font size="2"><b>$field{'name'}: </b></font></td><td><font size=2>$ext_profile[$id]</font></td></tr><tr>\n~;
			}
		}
	}
	return $output;
}

# returns the output for the post page
sub ext_viewinposts {
	my ($pusername, @ext_profile, $field, $id, $output, $fieldname, @options) = (shift);

	if ($pusername ne 'Guest') {
		@ext_profile = ext_get_profile($pusername);

		foreach $fieldname (ext_get_field_order) {
			$id = ext_get_field_id($fieldname);
			$field = ext_get_field($id);

			# make sure the field is visible and the user allowed to view the current field
			if (($field{'visible_in_posts'} == 1) &&
		   	($field{'active'} == 1) &&
		   	(ext_has_access($field{'p_users'},$field{'p_groups'}) == 1)) {
				if ($field{'p_displayfieldname'} == 1) { $displayedfieldname = "$field{'name'}: "; } else { $displayedfieldname = ""; }
				if ($output eq "") { $output = qq~<br>\n~; }
				# format the output dependend of the field type
				if ($field{'type'} eq "text") {
					@options = split(/\^/,$field{'options'});
					if ($options[3] ne "" && $ext_profile[$id] eq "") { $ext_profile[$id] = $options[3]; }
					if ($options[4] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
					if ($ext_profile[$id] ne "") { $output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~; }
				}
				elsif ($field{'type'} eq "text_multi" && $ext_profile[$id] ne "") {
					@options = split(/\^/,$field{'options'});
					if ($options[3] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
					$output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~;
				}
				elsif ($field{'type'} eq "select") {
					@options = split(/\^/,$field{'options'});
					if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
					$ext_profile[$id] = $options[$ext_profile[$id]];
					$output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~;
				}
				elsif ($field{'type'} eq "radiobuttons") {
					@options = split(/\^/,$field{'options'});
					if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
					$ext_profile[$id] = $options[$ext_profile[$id]];
					$output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~;
				}
				elsif ($field{'type'} eq "date" && $ext_profile[$id] ne "") {
					$ext_profile[$id] = ext_timeformat($ext_profile[$id]);
					$output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~;
				}
				elsif ($field{'type'} eq "checkbox") {
					if ($ext_profile[$id] == 1) { $ext_profile[$id] = $lang_ext{'true'} } else { $ext_profile[$id] = $lang_ext{'false'} }
					$output .= qq~$displayedfieldname$ext_profile[$id]<br>\n~;
				}
				elsif ($field{'type'} eq "spacer") {
					@options = split(/\^/,$field{'options'});
					if ($options[0] == 1) { $output .= qq~<br>\n~; }
					else { $output .= qq~<hr size="1" width="100%" class="hr">\n~; }
				}
				elsif ($field{'type'} eq "email" && $ext_profile[$id] ne "") { $output .= qq~$displayedfieldname<a href="mailto:$ext_profile[$id]">$ext_profile[$id]</a><br>\n~; }
				elsif ($field{'type'} eq "url" && $ext_profile[$id] ne "") {
					if($ext_profile[$id] !~ m~\Ahttp://~) { $ext_profile[$id] = "http://$ext_profile[$id]"; }
					$output .= qq~$displayedfieldname<a href="$ext_profile[$id]" target="_blank">$ext_profile[$id]</a><br>\n~;
				}
			}
		}
	}
	return $output;
}

# returns the output for the table header in memberlist
sub ext_memberlist_tableheader {
	my $field, $output, $fieldname;

	foreach $fieldname (ext_get_field_order) {
		$field = ext_get_field(ext_get_field_id($fieldname));

		# make sure the field is visible and the user allowed to view the current field
		if (($field{'visible_in_memberlist'} == 1) &&
		   ($field{'active'} == 1) &&
		   (ext_has_access($field{'m_users'},$field{'m_groups'}) == 1)) {
			if ($using_yams5 eq "1") {
				$output .= qq~<td class="catbg" style="border-width: 2px; border-style: outset; padding: 1px" bgcolor="#DEE7EF" align="center"><b><font size=2>$field{'name'}</font></b></td>\n~;
			} else {
				$output .= qq~<td class="catbg" bgcolor="$color{'catbg'}"><b><font size=2>$field{'name'}</font></b></td>\n~;
			}
		}
	}
	return $output;
}

# returns the number of additional fields showed in memberlist
sub ext_memberlist_get_headercount { # count the linebreaks to get the number of additional <td>s for the memberlist table
	my ($headers,$headercount) = (shift, 0);
	$headers =~ s~(\n)~$headercount++~eg;
	return $headercount;
}

# returns the output for the table tds in memberlist
sub ext_memberlist_tds {
	my ($pusername, $usergroup, @ext_profile, $field, $id, $output, $access, @users, $user, @groups, $group, $fieldname, @options, $count, $color) = (shift, $settings[7]);
	@ext_profile = ext_get_profile($pusername);

	$count = 0;
	foreach $fieldname (ext_get_field_order) {
		$id = ext_get_field_id($fieldname);
		$field = ext_get_field($id);

		# make sure the field is visible and the user allowed to view the current field
		if (($field{'visible_in_memberlist'} == 1) &&
		   ($field{'active'} == 1) &&
		   (ext_has_access($field{'m_users'},$field{'m_groups'}) == 1)) {
			$color = $count % 2 == 1 ? "windowbg" : "windowbg2";
			if ($using_yams5 eq "1") {
				$td_attributs = qq~class="windowbg2" style="border-top: #6394BD 1px solid; border-right: #6394BD 1px solid; padding: 2px" bgcolor="#F8F8F8" align="center" valign="middle"~;
			} else {
				$td_attributs = qq~class="$color" bgcolor="$color{'$color'}"~;
			}
			if ($field{'type'} eq "text") {
				@options = split(/\^/,$field{'options'});
				if ($options[3] ne "" && $ext_profile[$id] eq "") { $ext_profile[$id] = $options[3]; }
				if ($options[4] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "text_multi") {
				@options = split(/\^/,$field{'options'});
				if ($options[3] == 1) { $ext_profile[$id] = ext_parse_ubbc($ext_profile[$id], $pusername); }
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "select") {
				@options = split(/\^/,$field{'options'});
				if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
				$ext_profile[$id] = $options[$ext_profile[$id]];
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "radiobuttons") {
				@options = split(/\^/,$field{'options'});
				if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
				$ext_profile[$id] = $options[$ext_profile[$id]];
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "date") {
				$ext_profile[$id] = ext_timeformat($ext_profile[$id]);
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "checkbox") {
				if ($ext_profile[$id] == 1) { $ext_profile[$id] = $lang_ext{'true'} } else { $ext_profile[$id] = $lang_ext{'false'} }
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "spacer") {
				@options = split(/\^/,$field{'options'});
				if ($options[0] == 1) { $output .= qq~<td $td_attributs><font size=2><br></font></td>\n~; }
				else { $output .= qq~<td $td_attributs><hr size="1" width="100%" class="hr"></td>\n~; }
			}
			elsif ($field{'type'} eq "email") {
				if ($ext_profile[$id] ne "") { $ext_profile[$id] = qq~<a href="mailto:$ext_profile[$id]">$ext_profile[$id]</a>~; }
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			elsif ($field{'type'} eq "url") {
				if ($ext_profile[$id] !~ m~\Ahttp://~ && $ext_profile[$id] ne "") { $ext_profile[$id] = "http://$ext_profile[$id]"; }
				if ($ext_profile[$id] ne "") { $ext_profile[$id] = qq~<a href="$ext_profile[$id]" target="_blank">$ext_profile[$id]</a>~; }
				$output .= qq~<td $td_attributs><font size=2>$ext_profile[$id]</font>&nbsp;</td>\n~;
			}
			$count++;
		}
	}
	return $output;
}

# returns the edit mask of a field (used on registration and edit profile page)
sub ext_gen_editfield {
	my ($id, $pusername, @ext_profile, $output, $field, @options, $selected, $count, $required_prefix, $dayormonth, $dayormonthd, $dayormonthm) = (shift, shift);

	$field = ext_get_field($id);

	# if username is obmitted, we'll generate the code for the registration page
	if ($pusername ne "") {
		@ext_profile = ext_get_profile($pusername);
	}
	else {
		if ($field{'required_on_reg'} == 1) { $field{'name'} = "* ".$field{'name'}; }
	}

	&FromHTML($field{'comment'});

	# format the output dependend on field type
	if ($field{'type'} eq "text") {
		@options = split(/\^/,$field{'options'});
		if ($options[0] ne "") { $options[0] = qq~ maxlength="$options[0]"~; }
		if ($options[1] ne "") { $options[1] = qq~ size="$options[1]"~; }
		if ($options[3] ne "" && $ext_profile[$id] eq "") { $options[3] = qq~ value="$options[3]"~; } else { $options[3] = qq~ value="$ext_profile[$id]"~; }
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><input type="text"$options[0] name="ext_$id"$options[1] $options[3]></td></tr>\n~;
	}
	elsif ($field{'type'} eq "text_multi") {
		@options = split(/\^/,$field{'options'});
		if ($options[0] ne "" && $options[0] ne 0) { $field{'options'} = qq~
	<font size="1"><br>$lang_ext{'max_chars1'}$options[0]$lang_ext{'max_chars2'} <input value="$options[0]" size="~.length($options[0]).qq~" name="ext_~.$id.qq~_msgCL" disabled></font>
	<script language="JavaScript">
	<!--
	var ext_~.$id.qq~_supportsKeys = false
	function ext_~.$id.qq~_tick() {
	  ext_~.$id.qq~_calcCharLeft(document.forms[0])
	  if (!ext_~.$id.qq~_supportsKeys) timerID = setTimeout("ext_~.$id.qq~_tick()",$options[0])
	}

	function ext_~.$id.qq~_calcCharLeft(sig) {
	  clipped = false
	  maxLength = $options[0]
	  if (document.creator.ext_~.$id.qq~.value.length > maxLength) {
		document.creator.ext_~.$id.qq~.value = document.creator.ext_~.$id.qq~.value.substring(0,maxLength)
		charleft = 0
		clipped = true
	  } else {
		charleft = maxLength - document.creator.ext_~.$id.qq~.value.length
	  }
	  document.creator.ext_~.$id.qq~_msgCL.value = charleft
	  return clipped
	}

	ext_~.$id.qq~_tick();
	//-->
	</script>~; }
		else { $field{'options'} = ""; }
		if ($options[1] ne "") { $options[1] = qq~ rows="$options[1]"~; } else { $options[1] = qq~ rows="4"~; }
		if ($options[2] ne "") { $options[2] = qq~ cols="$options[2]"~; } else { $options[2] = qq~ cols="50"~; }
		$ext_profile[$id] =~ s/<br>/\n/g;
		$output .= qq~<tr><td valign="top"><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><font size=2><textarea name="ext_$id"$options[1]$options[2] wrap="virtual">$ext_profile[$id]</textarea></font>$field{'options'}</td></tr>\n~;
	}
	elsif ($field{'type'} eq "select") {
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><select name="ext_$id" size=1>\n~;
		@options = split(/\^/,$field{'options'});
		if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
		$count = 0;
		foreach (@options) {
			if ($count == $ext_profile[$id]) { $selected = " selected"; } else { $selected = ""; }
			$output .= qq~<option value="$count"$selected>$_\n~;
			$count++;
		}
		$output .= qq~</select></td></tr>~;
	}
	elsif ($field{'type'} eq "radiobuttons") {
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td>\n~;
		@options = split(/\^/,$field{'options'});
		if ($ext_profile[$id] > $#options || $ext_profile[$id] eq "") { $ext_profile[$id] = 0; }
		$count = 0;
		foreach (@options) {
			if ($count == $ext_profile[$id]) { $selected = qq~ checked="checked"~; } else { $selected = ""; }
			$output .= qq~<input type="radio" name="ext_$id" value="$count"$selected>$_\n~;
			$count++;
		}
		$output .= qq~</td></tr>~;
	}
	elsif ($field{'type'} eq "date") {
		if ($ext_profile[$id] !~ /[0-9\/]/) { $ext_profile[$id] = ""; }
		@options = split(/\//,$ext_profile[$id]);
		$dayormonthm = qq~ $txt{'564'} <input type="text" name="ext_~.$id.qq~_month" size="2" maxlength="2" value="$options[0]">~;
		$dayormonthd = qq~ $txt{'565'} <input type="text" name="ext_~.$id.qq~_day" size="2" maxlength="2" value="$options[1]">~;
		if (($memsettings[17] == 2 || $memsettings[17] == 3 || $memsettings[17] == 6) ||
		   ($timeselected == 2 || $timeselected == 3 || $timeselected == 6)) {
			$dayormonth=$dayormonthd.$dayormonthm;
		} else {
			$dayormonth=$dayormonthm.$dayormonthd;
		}
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><font size="1">$dayormonth $txt{'566'} <input type="text" name="ext_~.$id.qq~_year" size="4" maxlength="4" value="$options[2]"></font></td></tr>\n~;
	}
	elsif ($field{'type'} eq "checkbox") {
		if ($ext_profile[$id] == 1) { $ext_profile[$id] = " checked"; } else { $ext_profile[$id] = ""; }
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><input type="checkbox" name="ext_~.$id.qq~"$ext_profile[$id]></td></tr>\n~;
	}
	elsif ($field{'type'} eq "spacer") {
		@options = split(/\^/,$field{'options'});
		if ($options[1] == 1) {
			if ($options[0] == 1) { $output .= qq~<tr><td colspan=2><br></td></tr>\n~; }
			else { $output .= qq~<tr><td colspan=2><hr width="100%" size="1" class="hr"></td></tr>\n~; }
		}
	}
	elsif ($field{'type'} eq "email") {
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><input type="text" name="ext_$id" maxlength="40" size="30" value="$ext_profile[$id]"></td></tr>\n~;
	}
	elsif ($field{'type'} eq "url") {
		$output .= qq~<tr><td><font size=2><b>$field{'name'}: </b></font><br><font size="1">$field{'comment'}</font></td><td><input type="text" name="ext_$id" maxlength="40" size="50" value="$ext_profile[$id]"></td></tr>\n~;
	}
	return $output;
}

# returns the output for the edit profile page
sub ext_editprofile {
	my ($pusername, $part, $usergroup, $field, $id, $output, $fieldname, @options, $selected, $count) = (shift, shift, $settings[7]);

	foreach $fieldname (ext_get_field_order) {
		$id = ext_get_field_id($fieldname);
		$field = ext_get_field($id);

		# make sure the field is visible, the user allowed to edit the current field and only the requested fields are returned
		if (($field{'active'} == 1) && (($field{'editable_by_user'} == 1) || ($usergroup eq "Administrator")) &&
		   ((($part eq "required") && ($field{'required_on_reg'} == 1)) || (($part ne "required") && ($field{'required_on_reg'} != 1)))) {
			$output .= ext_gen_editfield($id, $pusername);
		}
	}
	if ($output ne "" && $part ne "required") { $output .= qq~<tr><td colspan=2><br><hr width="100%" size="1" class="hr"></td></tr>\n~; }
	return $output;
}

# returns if the submitted profile is valid, if not, return error messages
sub ext_validate_submition {
	my ($username, $pusername, $usergroup, %newprofile, @oldprofile, $output, $key, $value, $id, $field, @options) = (shift, shift, $settings[7], %FORM);
	while(($key,$value) = each(%newprofile)) {
		# only validate fields with prefix "ext_"
		if ($key =~ /^ext_(\d+)/) {
			$id = $1;
			$field = ext_get_field($id);

			if (!$field{'name'}) { $output .= $lang_ext{'field_not_existing1'}.$id.$lang_ext{'field_not_existing2'}."<br>\n"; }

			# check if user is allowed to modify this setting
			if (($field{'editable_by_user'} == 0 && $usergroup ne "Administrator") ||
			   ($username ne $pusername && $usergroup ne "Administrator")) {
				$output .= $field{'name'}.": ".$lang_ext{'not_allowed_to_modify'}."<br>\n";
			}

			# check if setting is valid
			if ($field{'type'} ne "text_multi" && $value =~ /[\n\r]/) { $output .= $field{'name'}.": ".$lang_ext{'invalid_char'}."<br>\n"; }
			if ($field{'type'} eq "text") {
				@options = split(/\^/,$field{'options'});
				# don't fill it with default value yet, it might be required on registration
				# if ($options[3] ne "" && $value eq "") { $value = $options[3]; $FORM{'ext_'.$id} = $value; }
				if ($options[0]+0 > 0 && length($value) > $options[0]) { $output .= $field{'name'}.": ".$lang_ext{'too_long'}."<br>\n"; }
				if ($options[2] == 1 && $value !~ /[0-9\.,]+/ && $value ne "") { $output .= $field{'name'}.": ".$lang_ext{'not_numeric'}."<br>\n"; }
				&ToHTML($value);
				$FORM{'ext_'.$id} = $value;
			}
			elsif ($field{'type'} eq "text_multi") {
				@options = split(/\^/,$field{'options'});
				if ($options[0]+0 > 0 && length($value) > $options[0]) { $output .= $field{'name'}.": ".$lang_ext{'too_long'}."<br>\n"; }
				&ToHTML($value);
				$value =~ s/\n/<br>/g;
				$value =~ s/\r//g;
				$FORM{'ext_'.$id} = $value;
			}
			elsif ($field{'type'} eq "select" || $field{'type'} eq "radiobuttons") {
				@options = split(/\^/,$field{'options'});
				if ($value !~ /[0-9]/) { $output .= $field{'name'}.": ".$lang_ext{'not_numeric'}."<br>\n"; }
				if ($value < 0) { $output .= $field{'name'}.": ".$lang_ext{'too_small'}."<br>\n"; }
				if ($value > $#options) { $output .= $field{'name'}.": ".$lang_ext{'option_does_not_exist'}."<br>\n"; }
			}
			elsif ($field{'type'} eq "date" && $value ne "") {
				if ($value !~ /[0-9]/) { $output .= $field{'name'}.": ".$lang_ext{'not_numeric'}."<br>\n"; }
				if ($key eq "ext_".$id."_day") {
					if ($value < 1) { $output .= $field{'name'}.": ".$lang_ext{'too_small'}."<br>\n"; }
					if ($value > 31) { $output .= $field{'name'}.": ".$lang_ext{'too_big'}."<br>\n"; }
					if (length($value) == 1) { $FORM{'ext_'.$id.'_day'} = "0".$value; }
				}
				elsif ($key eq "ext_".$id."_month") {
					if ($value < 1) { $output .= $field{'name'}.": ".$lang_ext{'too_small'}."<br>\n"; }
					if ($value > 12) { $output .= $field{'name'}.": ".$lang_ext{'too_big'}."<br>\n"; }
					if (length($value) == 1) { $FORM{'ext_'.$id.'_month'} = "0".$value; }
				}
				elsif ($key eq "ext_".$id."_year") {
					if (length($value) != 4) { $output .= $field{'name'}.": ".$lang_ext{'invalid_year'}."<br>\n"; }
				}
				$FORM{'ext_'.$id} = $FORM{'ext_'.$id.'_month'} ."\/". $FORM{'ext_'.$id.'_day'} ."\/". $FORM{'ext_'.$id.'_year'};
				if ($FORM{'ext_'.$id} !~ /^\d\d\/\d\d\/\d\d\d\d$/) { $FORM{'ext_'.$id} = ""; }
			}
			elsif ($field{'type'} eq "checkbox") {
				if ($value ne "") { $FORM{'ext_'.$id} = 1; } else { $FORM{'ext_'.$id} = 0; }
			}
			elsif ($field{'type'} eq "email" && $value ne "") {
				# uses the code from Profile.pl without further checking...
				if ($value !~ /^[0-9A-Za-z@\._\-]+$/) { $output .= $field{'name'}.": ".$lang_ext{'invalid_char'}."<br>\n"; }
				if (($value =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($value !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?$/)) { $output .= $field{'name'}.": ".$lang_ext{'invalid_char'}."<br>\n"; }
				&ToHTML($value);
				$FORM{'ext_'.$id} = $value;
			}
			elsif ($field{'type'} eq "url" && $value ne "") {
				&ToHTML($value);
				$FORM{'ext_'.$id} = $value;
			}
		}
	}

	# check if required fields are filled and add missing fields to $FORM, just to be on the saver side
	@oldprofile = ext_get_profile($pusername);
	$id = 0;
	foreach (ext_get_fields) {
		$field = ext_get_field($id);
		if ($field{'type'} eq "checkbox" || $field{'type'} eq "select" || $field{'type'} eq "radiobuttons") {
			if ($FORM{'ext_'.$id} eq "") { $FORM{'ext_'.$id} = 0; }
		}
		# load old settings which where invisible/restricted
		if ($field{'editable_by_user'} == 0 && $usergroup ne "Administrator") {
			$FORM{'ext_'.$id} = $oldprofile[$id];
		}
		# if setting didn't get submitted, load old value
		if (!defined $FORM{'ext_'.$id} && $field{'type'} ne 'date') { $FORM{'ext_'.$id} = $oldprofile[$id]; }
		if ($field{'required_on_reg'} == 1 && $FORM{'ext_'.$id} eq "") { $output .= $field{'name'}.": ".$lang_ext{'required'}."<br>\n"; }
		# only fill with default value AFTER check of requirement
		if ($field{'type'} eq "text" && $FORM{'ext_'.$id} eq "") {
			@options = split(/\^/,$field{'options'});
			if ($options[3] ne "") { $FORM{'ext_'.$id} = $options[3] }
		}
		$id++;
	}

	return $output;
}

# stores the submitted profile on disk
sub ext_saveprofile {
	my ($pusername, $id, $isdefault, $field, @options) = (shift, 0, 1);

	# note: we expect the new profile to be validated already
	# now check if default settings have been selected. If so, we can delete the profile file to save space.

	foreach (ext_get_fields) {
		$field = ext_get_field($id);
		if ($field{'type'} eq "text") {
			@options = split(/\^/,$field{'options'});
			if ($options[3] ne $FORM{"ext_".$id}) { $isdefault = 0; }
		}
		elsif ($field{'type'} eq "text_multi" || $field{'type'} eq "date" || $field{'type'} eq "email" || $field{'type'} eq "url") {
			if ($FORM{"ext_".$id} ne "") { $isdefault = 0; }
		}
		elsif ($field{'type'} eq "select" || $field{'type'} eq "radiobuttons" || $field{'type'} eq "checkbox") {
			if ($FORM{"ext_".$id} ne 0) { $isdefault = 0; }
		}
		$id++;
	}

	if ($isdefault == 0) {
		$id = 0;
		fopen(FILE, ">$memberdir/$pusername.ext") || &fatal_error($lang_ext{'cannot_write_file'}.$pusername.".ext");
		foreach (ext_get_fields) {
			print FILE $FORM{'ext_'.$id} . "\n";
			$id++;
		}
		fclose(FILE);
	}
	else {
		if (-e "$memberdir/$pusername.ext") { unlink("$memberdir/$pusername.ext"); }
	}
}

# returns the output for the registration page
sub ext_register {
	my $field, $id, $output, $fieldname, @options, @selected;

	foreach $fieldname (ext_get_field_order) {
		$id = ext_get_field_id($fieldname);
		$field = ext_get_field($id);
		if ($field{'active'} == 1 && $field{'editable_by_user'} == 1 && $field{'required_on_reg'} != 0) {
			$output .= ext_gen_editfield($id);
		}
	}

	return $output;
}

# returns the output for the Extended Profile Controls in admin center
sub ext_admin {
	my $field, $id, $output, $fieldname, @options, $active, @selected;

	&is_admin;
	$yymain .= qq~
<table border="0" align="center" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" width="90%">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
      <img src="$imagesdir/profile.gif" alt="" border="0"><font class="text1" color="$color{'titletext'}" size="1"> <b>$lang_ext{'Profiles_Controls'}</b></font>
    </td>
  </tr>
  <tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" colspan="3"><br><font size="1">$lang_ext{'admin_description'}</font><br><br></td>
  </tr>
</table>

<br>

<table border="0" align="center" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" width="90%">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
      <img src="$imagesdir/profile.gif" alt="" border="0"><font class="text1" color="$color{'titletext'}" size="1"> <b>$lang_ext{'edit_title'}</b></font>
    </td>
  </tr>
  <tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" colspan="3"><br><font size="1">$lang_ext{'edit_description'}</font><br><br></td>
  </tr>
  <tr>
    <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top">
    <table border="0" cellspacing="0" cellpadding="3" width="100%">
      <tr>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'active'}</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'field_name'}</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'field_type'}</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'actions'}</td>
      </tr>
~;
	if (!ext_get_field_order) {
		$yymain .= qq~<td colspan="4" align="center"><font size="2"><br><i>$lang_ext{'no_additional_fields_set'}</i><br><br></font></td>~;
	} else {
		foreach $fieldname (ext_get_field_order) {
			$id = ext_get_field_id($fieldname);
			$field = ext_get_field($id);
			if ($field{'type'} eq "text") { $selected[0] = " selected"; } else { @selected[0] = ""; }
			if ($field{'type'} eq "text_multi") { $selected[1] = " selected"; } else { @selected[1] = ""; }
			if ($field{'type'} eq "select") { $selected[2] = " selected"; } else { @selected[2] = ""; }
			if ($field{'type'} eq "radiobuttons") { $selected[3] = " selected"; } else { $selected[3] = ""; }
			if ($field{'type'} eq "checkbox") { $selected[4] = " selected"; } else { @selected[4] = ""; }
			if ($field{'type'} eq "date") { $selected[5] = " selected"; } else { $selected[5] = ""; }
			if ($field{'type'} eq "email") { $selected[6] = " selected"; } else { $selected[6] = ""; }
			if ($field{'type'} eq "url") { $selected[7] = " selected"; } else { $selected[7] = ""; }
			if ($field{'type'} eq "spacer") { $selected[8] = " selected"; } else { $selected[8] = ""; }
			if ($field{'active'} == 1) { $active = " checked"; } else { $active = ""; }
$yymain .= qq~
      <tr>
        <form action="$cgi;action=ext_edit" method="POST">
	<td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <input name="id" type="hidden" value="$id">
	  <input type="checkbox" name="active" value="1"$active>
	</td>
	<td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <input name="name" value="$field{'name'}" size="30">
	</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <select name="type" size=1>
	    <option value="text"$selected[0]>$lang_ext{'text'}
	    <option value="text_multi"$selected[1]>$lang_ext{'text_multi'}
	    <option value="select"$selected[2]>$lang_ext{'select'}
	    <option value="radiobuttons"$selected[3]>$lang_ext{'radiobuttons'}
	    <option value="checkbox"$selected[4]>$lang_ext{'checkbox'}
	    <option value="date"$selected[5]>$lang_ext{'date'}
	    <option value="email"$selected[6]>$lang_ext{'email'}
	    <option value="url"$selected[7]>$lang_ext{'url'}
	    <option value="spacer"$selected[8]>$lang_ext{'spacer'}
	  </select>
	</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <input type="submit" name="apply" value="$lang_ext{'apply'}">
	  <input type="submit" name="options" value="$lang_ext{'options'}">
	  <input type="submit" name="delete" value="$lang_ext{'delete'}">
	</td>
	</form>
      </tr>
~;
		}
	}

$yymain .= qq~
    </table>
    </td>
  </tr>
</table>

<br>

<table border="0" align="center" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" width="90%">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
      <img src="$imagesdir/profile.gif" alt="" border="0"><font class="text1" color="$color{'titletext'}" size="1"> <b>$lang_ext{'create_new_title'}</b></font>
    </td>
  </tr>
  <tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" colspan="3"><br><font size="1">$lang_ext{'create_new_description'}</font><br><br></td>
  </tr>
  <tr>
    <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top">
    <table border="0" cellspacing="0" cellpadding="3" width="100%">
      <tr>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'field_name'}</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'field_type'}</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">$lang_ext{'actions'}</td>
      </tr>
      <tr>
        <form action="$cgi;action=ext_create" method="POST">
	<td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <input name="name" size="30">
	</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <select name="type" size=1>
	    <option value="text" selected>$lang_ext{'text'}
	    <option value="text_multi">$lang_ext{'text_multi'}
	    <option value="select">$lang_ext{'select'}
	    <option value="radiobuttons">$lang_ext{'radiobuttons'}
	    <option value="checkbox">$lang_ext{'checkbox'}
	    <option value="date">$lang_ext{'date'}
	    <option value="email">$lang_ext{'email'}
	    <option value="url">$lang_ext{'url'}
	    <option value="spacer">$lang_ext{'spacer'}
	  </select>
	</td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" align="center">
	  <input type="submit" name="create" value="$lang_ext{'create_field'}">
	</td>
	</form>
      </tr>
    </table>
    </td>
  </tr>
</table>

<br>

<table border="0" align="center" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" width="90%">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
      <img src="$imagesdir/profile.gif" alt="" border="0"><font class="text1" color="$color{'titletext'}" size="1"> <b>$lang_ext{'reorder_title'}</b></font>
    </td>
  </tr>
  <tr>
    <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top">
      <table border="0" cellspacing="0" cellpadding="6" width="100%">
      <tr>
        <form action="$cgi;action=ext_reorder" method="POST">
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" valign="top">
          <textarea name="reorder" cols=30 rows=6 wrap="virtual">~;

	foreach $fieldname (ext_get_field_order) { $yymain .= $fieldname."\n"; }

          $yymain .= qq~</textarea>
        </td>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top" align="left" width="100%">
          $lang_ext{'reorder_description'}<br><br>
          <input type="submit" name="reorder_submit" value="$lang_ext{'reorder'}">
        </td>
        </form>
      </tr>
    </table>
    </td>
  </tr>
</table>
~;
	$yytitle = $lang_ext{'Profiles_Controls'};
	&template;
	exit;
}

# reorders the fields as submitted
sub ext_admin_reorder {
	&is_admin;

	$FORM{'reorder'} =~ tr/\r//d;
	$FORM{'reorder'} =~ s~\A[\s\n]+~~;
	$FORM{'reorder'} =~ s~[\s\n]+\Z~~;
	$FORM{'reorder'} =~ s~\n\s*\n~\n~g;
	ToHTML($FORM{'reorder'});
	fopen(FILE, ">$vardir/extended_profiles_order.txt") || &fatal_error("$txt{'23'} extended_profiles_order.txt");
	print FILE $FORM{'reorder'}."\n";
	fclose(FILE);

	$yySetLocation = qq~$cgi;action=ext_admin~;
	&redirectexit;
}

# creates a new field as submitted
sub ext_admin_create {
	my @contents;
	&is_admin;

	ToHTML($FORM{'name'});

	fopen(FILE, ">>$vardir/extended_profiles_fields.txt") || &fatal_error("$txt{'23'} extended_profiles_fields.txt");
	print FILE "$FORM{'name'}|$FORM{'type'}||1||0|1|||0|||0|0|||1\n";
	fclose(FILE);

	fopen(FILE, ">>$vardir/extended_profiles_order.txt") || &fatal_error("$txt{'23'} extended_profiles_order.txt");
	print FILE $FORM{'name'}."\n";
	fclose(FILE);

	opendir(DIR, "$memberdir");
	@contents = grep {/\.ext$/} readdir(DIR);
	closedir(DIR);

	foreach (@contents) {
		fopen(FILE, ">>$memberdir/$_") || &fatal_error($lang_ext{'cannot_write_file'}.$_);
		print FILE "\n";
		fclose(FILE);
	}

	$yySetLocation = qq~$cgi;action=ext_admin~;
	&redirectexit;
}

# performs all actions done in the edit profile field panel
sub ext_admin_edit {
	my $field, @fields, @order, $type, $active, $id, $name, $oldname, $req1, $req2, $req3, $v_check, $p_check, $p_d_check, $m_check, $editable_check, $is_numeric, $ubbc, @options, $check1, $check2, @contents, @old_content;
	&is_admin;

	if ($FORM{'apply'} ne "") {
		ToHTML($FORM{'name'});
		$name = $FORM{'name'};
		$id = $FORM{'id'};
		$type = $FORM{'type'};
		$active = $FORM{'active'}; if ($active ne "") { $active = "1"; } else { $active = "0"; }

		@fields = ext_get_fields;
		@_ = split(/\|/,$fields[$FORM{'id'}]);
		$oldname = $_[0];
		$fields[$FORM{'id'}] = "$name|$type|$_[2]|$active|$_[4]|$_[5]|$_[6]|$_[7]|$_[8]|$_[9]|$_[10]|$_[11]|$_[12]|$_[13]|$_[14]|$_[15]|$_[16]";
		fopen(FILE, ">$vardir/extended_profiles_fields.txt") || &fatal_error("$txt{'23'} extended_profiles_fields.txt");
		foreach (@fields) { print FILE "$_\n"; }
		fclose(FILE);

		@order = ext_get_field_order;
		$id = 0;
		foreach (@order) {
			if ($oldname eq $_) { $order[$id] = $name; last; }
			$id++;
		}
		fopen(FILE, ">$vardir/extended_profiles_order.txt") || &fatal_error("$txt{'23'} extended_profiles_order.txt");
		foreach (@order) { print FILE "$_\n"; }
		fclose(FILE);

		$yySetLocation = qq~$cgi;action=ext_admin~;
		&redirectexit;
	}
	elsif ($FORM{'options'} ne "") {
		$field = ext_get_field($FORM{'id'});
		if ($field{'active'} == 1) { $active = $lang_ext{'true'}; } else { $active = $lang_ext{'false'}; }
		if ($field{'required_on_reg'} == 1) { $req1 = ""; $req2 = " checked"; $req3 = ""; }
		elsif ($field{'required_on_reg'} == 2) { $req1 = ""; $req2 = ""; $req3 = " checked"; }
		else { $req1 = " checked"; $req2 = ""; $req3 = ""; }
		if ($field{'visible_in_viewprofile'} == 1) { $v_check = " checked"; } else { $v_check = ""; }
		if ($field{'visible_in_posts'} == 1) { $p_check = " checked"; } else { $p_check = ""; }
		if ($field{'p_displayfieldname'} == 1) { $p_d_check = " checked"; } else { $p_d_check = ""; }
		if ($field{'visible_in_memberlist'} == 1) { $m_check = " checked"; } else { $m_check = ""; }
		if ($field{'editable_by_user'} == 1) { $editable_check = " checked"; } else { $editable_check = ""; }
		$yymain .= qq~
<form action="$cgi;action=ext_edit2" method="POST">
<table border="0" align="center" cellspacing="1" cellpadding="4" bgcolor="$color{'bordercolor'}" class="bordercolor" width="90%">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
      <img src="$imagesdir/profile.gif" alt="" border="0"><font class="text1" color="$color{'titletext'}" size="1"> <b>$lang_ext{'options_title'}</b></font>
    </td>
  </tr>
  <tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}" colspan="3"><br><font size="1">$lang_ext{'options_description'}</font><br><br></td>
  </tr>
  <tr>
    <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top">
      <table border="0" cellspacing="0" cellpadding="6" width="100%">
      <tr>
        <td><b>$lang_ext{'active'}:</b> $active</td>
	<td align="center"><b>$lang_ext{'field_name'}:</b> $field{'name'}</td>
	<td align="center"><b>$lang_ext{'field_type'}:</b> $lang_ext{$field{'type'}}</td>
	<td align="right"><a href="$cgi;action=ext_admin">&lt;-- change these settings</a></td>
      </tr>
    </table>
    </td>
  </tr>
  <tr>
    <td bgcolor="$color{'windowbg2'}" class="windowbg2" width="100%" valign="top">
      <table border="0" cellspacing="0" cellpadding="6" width="100%">
~;
		if ($field{'type'} eq "text") {
			@options = split(/\^/,$field{'options'});
			if ($options[2] == 1) { $is_numeric = " checked" } else { $is_numeric = "" }
			if ($options[4] == 1) { $ubbc = " checked" } else { $ubbc = "" }
			$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'limit_len'}: </b></font><br>$lang_ext{'limit_len_description'}</td>
	<td><input name="limit_len" size="5" value='$options[0]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'width'}: </b></font><br>$lang_ext{'width_description'}</td>
	<td><input name="width" size="5" value='$options[1]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'is_numeric'}: </b></font><br>$lang_ext{'is_numeric_description'}</td>
	<td><input name="is_numeric" type="checkbox" value="1"$is_numeric></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'default'}: </b></font><br>$lang_ext{'default_description'}</td>
	<td><input name="default" size="50" value='$options[3]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'ubbc'}: </b></font><br>$lang_ext{'ubbc_description'}</td>
	<td><input name="ubbc" type="checkbox" value="1"$ubbc></td>
      </tr>
~;
		}
		elsif ($field{'type'} eq "text_multi") {
			@options = split(/\^/,$field{'options'});
			if ($options[3] == 1) { $ubbc = " checked" } else { $ubbc = "" }
			$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'limit_len'}: </b></font><br>$lang_ext{'limit_len_description'}</td>
	<td><input name="limit_len" size="5" value='$options[0]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'rows'}: </b></font><br>$lang_ext{'rows_description'}</td>
	<td><input name="rows" size="5" value='$options[1]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'cols'}: </b></font><br>$lang_ext{'cols_description'}</td>
	<td><input name="cols" size="5" value='$options[2]'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'ubbc'}: </b></font><br>$lang_ext{'ubbc_description'}</td>
	<td><input name="ubbc" type="checkbox" value="1"$ubbc></td>
      </tr>
~;
		}
		elsif ($field{'type'} eq "select" || $field{'type'} eq "radiobuttons") {
			@options = split(/\^/,$field{'options'});
			$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'s_options'}: </b></font><br>$lang_ext{'s_options_description'}</td>
	<td><textarea name="options" cols=30 rows=3 wrap="virtual">~;

			foreach (@options) { $yymain .= qq~$_\n~; }

			$yymain .= qq~</textarea></td>
      </tr>
~;
		}
		elsif ($field{'type'} eq "spacer") {
			@options = split(/\^/,$field{'options'});
			if ($options[0] == 1) { $check2 = " checked"; $check1 = ""; } else {  $check2 = ""; $check1 = " checked"; }
			if ($options[1] == 1) { $options[1] = " checked"; } else { $options[1] = ""; }
			$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'hr_or_br'}: </b></font><br>$lang_ext{'hr_or_br_description'}</td>
	<td>
	  <input name="hr_or_br" type="radio" value="0"$check1>$lang_ext{'hr'}
	  <input name="hr_or_br" type="radio" value="1"$check2>$lang_ext{'br'}
	</td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'visible_in_editprofile'}: </b></font><br>$lang_ext{'visible_in_editprofile_description'}</td>
	<td><input name="visible_in_editprofile" type="checkbox" value="1"$options[1]></td>
      </tr>
~;
		}
		$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'comment'}: </b></font><br>$lang_ext{'comment_description'}</td>
	<td><input name="comment" size="50" value='$field{'comment'}'></td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'required_on_reg'}: </b></font><br>$lang_ext{'required_on_reg_description'}</td>
	<td>
	  <input name="required_on_reg" type="radio" value="1"$req2> $lang_ext{'req1'}<br>
	  <input name="required_on_reg" type="radio" value="0"$req1> $lang_ext{'req0'}<br>
	  <input name="required_on_reg" type="radio" value="2"$req3> $lang_ext{'req2'}
	</td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'visible_in_viewprofile'}: </b></font><br>$lang_ext{'visible_in_viewprofile_description'}</td>
	<td>
	  <input name="visible_in_viewprofile" type="checkbox" value="1"$v_check><br>
	  <table border="0" cellspacing="4" cellpadding="0">
	    <tr><td>$lang_ext{'v_users'}: </td><td><input name="v_users" value="$field{'v_users'}"></td></tr>
	    <tr><td>$lang_ext{'v_groups'}: </td><td><input name="v_groups" value="$field{'v_groups'}"></td></tr>
	  </table>
	</td>
      </tr>
      <tr>
        <td valign="top"><font size="2"><b>$lang_ext{'visible_in_posts'}: </b></font><br>$lang_ext{'visible_in_posts_description'}</td>
	<td>
	  <input name="visible_in_posts" type="checkbox" value="1"$p_check><br>
	  <table border="0" cellspacing="4" cellpadding="0">
	    <tr><td>$lang_ext{'display_fieldname'}: </td><td><input name="p_displayfieldname" type="checkbox" value="1"$p_d_check></td></tr>
	    <tr><td>$lang_ext{'p_users'}: </td><td><input name="p_users" value="$field{'p_users'}"></td></tr>
	    <tr><td>$lang_ext{'p_groups'}: </td><td><input name="p_groups" value="$field{'p_groups'}"></td></tr>
	  </table>
	</td>
      </tr>
      <tr>
        <td><font size="2"><b>$lang_ext{'visible_in_memberlist'}: </b></font><br>$lang_ext{'visible_in_memberlist_description'}</td>
	<td>
	  <input name="visible_in_memberlist" type="checkbox" value="1"$m_check><br>
	  <table border="0" cellspacing="4" cellpadding="0">
	    <tr><td>$lang_ext{'m_users'}: </td><td><input name="m_users" value="$field{'m_users'}"></td></tr>
	    <tr><td>$lang_ext{'m_groups'}: </td><td><input name="m_groups" value="$field{'m_groups'}"></td></tr>
	  </table>
	</td>
      </tr>
~;
		if ($field{'type'} ne "spacer") {
$yymain .= qq~
      <tr>
        <td><font size="2"><b>$lang_ext{'editable_by_user'}: </b></font><br>$lang_ext{'editable_by_user_description'}</td>
	<td>
	  <input name="editable_by_user" type="checkbox" value="1"$editable_check>
	</td>
      </tr>
~;
		}
$yymain .= qq~
      <tr>
        <td colspan="2" align="center">
	  <input name="id" type="hidden" value="$FORM{'id'}">
	  <input name="name" type="hidden" value="$FORM{'name'}">
	  <input name="type" type="hidden" value="$FORM{'type'}">
	  <input name="active" type="hidden" value="$FORM{'active'}">~;
	  	if ($field{'type'} eq "spacer") { $yymain .= qq~<input name="editable_by_user" type="hidden" value="1">~; }
$yymain .= qq~
	  <input type="submit" name="save" value="$lang_ext{'Save'}">
	</td>
      </tr>
      </table>
    </td>
  </tr>
</table>
</form>
~;
		$yytitle = "$lang_ext{'Profiles_Controls'} - $lang_ext{'options_title'}";
		&template;
		exit;
	}
	elsif ($FORM{'delete'} ne "") {
		$id = 0;
		$field = ext_get_field($FORM{'id'});
		@fields = ext_get_fields;
		fopen(FILE, ">$vardir/extended_profiles_fields.txt") || &fatal_error("$txt{'23'} extended_profiles_fields.txt");
		foreach (@fields) {
			if ($FORM{'id'} != $id) { print FILE "$_\n"; }
			$id++;
		}
		fclose(FILE);

		@order = ext_get_field_order;
		fopen(FILE, ">$vardir/extended_profiles_order.txt") || &fatal_error("$txt{'23'} extended_profiles_order.txt");
		foreach (@order) {
			if ($_ ne $field{'name'}) { print FILE "$_\n"; }
		}
		fclose(FILE);

		opendir(DIR, "$memberdir");
		@contents = grep {/\.ext$/} readdir(DIR);
		closedir(DIR);

		foreach (@contents) {
			$id = 0;
			fopen(FILE, "$memberdir/$_") || &fatal_error($lang_ext{'cannot_write_file'}.$_);
			@old_content = <FILE>;
			fclose(FILE);
			fopen(FILE, ">$memberdir/$_") || &fatal_error($lang_ext{'cannot_write_file'}.$_);
			foreach (@fields) {
				if ($id != $FORM{'id'}) { print FILE $old_content[$id]; }
				$id++;
			}
			fclose(FILE);
		}

		$yySetLocation = qq~$cgi;action=ext_admin~;
		&redirectexit;
	}
}

# modifies a field as submitted
sub ext_admin_edit2 {
	my @fields, @options;
	&is_admin;

	ToHTML($FORM{'name'});
	ToHTML($FORM{'comment'});
	if ($FORM{'active'} eq "") { $FORM{'active'} = 0; }
	if ($FORM{'required_on_reg'} eq "") { $FORM{'required_on_reg'} = 0; }
	if ($FORM{'visible_in_viewprofile'} eq "") { $FORM{'visible_in_viewprofile'} = 0; }
	if ($FORM{'visible_in_posts'} eq "") { $FORM{'visible_in_posts'} = 0; }
	if ($FORM{'p_displayfieldname'} eq "") { $FORM{'p_displayfieldname'} = 0; }
	if ($FORM{'visible_in_memberlist'} eq "") { $FORM{'visible_in_memberlist'} = 0; }
	if ($FORM{'editable_by_user'} eq "") { $FORM{'editable_by_user'} = 0; }
	$FORM{'v_users'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	$FORM{'v_groups'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	$FORM{'p_users'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	$FORM{'p_groups'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	$FORM{'m_users'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	$FORM{'m_groups'} =~ s/^(\s)*(.+?)(\s)*$/$2/;
	if ($FORM{'type'} eq "text") {
		if ($FORM{'width'} == 0) { $FORM{'width'} = ""; }
		if ($FORM{'is_numeric'} eq "") { $FORM{'is_numeric'} = 0; }
		if ($FORM{'ubbc'} eq "") { $FORM{'ubbc'} = 0; }
		$FORM{'options'} = "$FORM{'limit_len'}^$FORM{'width'}^$FORM{'is_numeric'}^$FORM{'default'}^$FORM{'ubbc'}";
	}
	elsif ($FORM{'type'} eq "text_multi") {
		if ($FORM{'rows'} == 0) { $FORM{'rows'} = ""; }
		if ($FORM{'cols'} == 0) { $FORM{'cols'} = ""; }
		if ($FORM{'ubbc'} eq "") { $FORM{'ubbc'} = 0; }
		$FORM{'options'} = "$FORM{'limit_len'}^$FORM{'rows'}^$FORM{'cols'}^$FORM{'ubbc'}";
	}
	elsif ($FORM{'type'} eq "select" || $FORM{'type'} eq "radiobuttons") {
		$FORM{'options'} =~ tr/\r//d;
		$FORM{'options'} =~ s~\A[\s\n]+~~;
		$FORM{'options'} =~ s~[\s\n]+\Z~~;
		$FORM{'options'} =~ s~\n\s*\n~\n~g;
		@options = split(/\n/,$FORM{'options'});
		$FORM{'options'} = "";
		foreach (@options) { $FORM{'options'} .= "\^".$_; }
		$FORM{'options'} =~ s/^\^//;
	}
	elsif ($FORM{'type'} eq "spacer") {
		if ($FORM{'visible_in_editprofile'} eq "") { $FORM{'visible_in_editprofile'} = 0; }
		$FORM{'options'} = "$FORM{'hr_or_br'}^$FORM{'visible_in_editprofile'}";
	}

	@fields = ext_get_fields;
	$fields[$FORM{'id'}] = "$FORM{'name'}|$FORM{'type'}|$FORM{'options'}|$FORM{'active'}|$FORM{'comment'}|$FORM{'required_on_reg'}|$FORM{'visible_in_viewprofile'}|$FORM{'v_users'}|$FORM{'v_groups'}|$FORM{'visible_in_posts'}|$FORM{'p_users'}|$FORM{'p_groups'}|$FORM{'p_displayfieldname'}|$FORM{'visible_in_memberlist'}|$FORM{'m_users'}|$FORM{'m_groups'}|$FORM{'editable_by_user'}";
	fopen(FILE, ">$vardir/extended_profiles_fields.txt") || &fatal_error("$txt{'23'} extended_profiles_fields.txt");
	foreach (@fields) { print FILE "$_\n"; }
	fclose(FILE);

	$yySetLocation = qq~$cgi;action=ext_admin~;
	&redirectexit;
}

1;
