<id>
Upgrade SP 1 to SP 1.1
</id>

<version>
SP 1.1
</version>

<author>
Corey Chapman, Bjoern Berg (with assistance from the YaBB Community)
</author>

<homepage>
http://www.yabbforum.com
</homepage>

<mod info>
This mod fixes problems that were not reported by SP 1 beta testers, as well as adding some layout fixes and performance improvements. Please note that this is a large file and modifies every source file. You may have to install it manually or skip some steps if you have a lot of mods installed on your YaBB.

Before installing this mod:
- If you have YaBB.cgi version: Open this mod and change YaBB.pl to YaBB.cgi
- If you have colwidth_fix mod installed: uninstall it
- If you have the /me mod installed: uninstall it
- If you have a non-english language pack: Remove the last two entries < search for>XX< /search for> and < replace>XX< /replace> from the english.lng section
- If you have a non-english language pack: rename english.lng to your language file name

After installing this mod:
- Replace your old fader.js with the new one in this package
- Replace your help files in YaBBHelp with the new html files in this package
- If you have a charset meta tag in your template: replace the character set in it with <yabb charset>
- Optional: replace your images in YaBBImages with the new ones in this package
- Recommendation: Set the click log time in the Admin Center to a small number like 120 to speed your forum up
- Recommendation: If you are using the default template, replace it with the one provided in this pack

Some of the changes:
New javascript in image tags vulnerability fixed - Michael Prager
Text 188 of english.lng removed - Bjoern Berg
Text 93 of english.lng fixed - Bjoern Berg
Miscoded input box fixed - KIDiddles
Blank board after deleting a board removed - Bjoern Berg
Flood protection IP variable fixed so it works - GreLI[S2]
Version 2.02 of fader.js - NRg
Day wraparound bug in time calculations (that affected clicklog) fixed - BHRA Webmaster
Time check on clicklog typo fixed - Bjoern Berg
Long Image Tag URL's do not wrap now - Corey Chapman
Copyright/Comment URL's and dates updated - Corey Chapman
Menu separator added to admin links on posts for text menu - Corey Chapman
HTML header added to printpage.pl so it works properly - Archon
/me now highlights the whole line and adds the proper actioner's name - Corey Chapman, Michael Rodriguez-Torrent
Hardcoded "on" removed from sendtopic.pl - Corey Chapman
Quotes in maintenance text no longer causes a 500 - Bjoern Berg
Various HTML fixes to messageindex.pl, search.pl and display.pl - dOCda S, Bjoern Berg
Manageboards.pl reorder bug fixed - dOCda S
Tim Ceuppens' name fixed in admin center - Corey Chapman
Reminder function is allowed when guest access is off - Bjoern Berg
Extra blank lines inside news box of "edit news" removed - Corey Chapman
Members removed from moderator lists if they are deleted (security fix) - Bjoern Berg
Marking a board read directs to the BoardIndex instead of the same MessageIndex now - Bjoern Berg
Shared login now contains 'Forgot password?' link. - Bjoern Berg.
[ and ] in templates now show up in "edit template" textarea. - Bjoern Berg
Main search screen had DHTML compatibility for some sites so ID's were removed - Corey Chapman
Version info updated - Corey Chapman
HTML fix to password reminder box - Corey Chapman, Samm
Flood control disabled for administrators - rehlbe
Show all in the memberlist is sorted as Aa-Zz instead of A-Z a-z now - Uwe Wiedemann
Default menu separator in the language file changed to a | with font tags - Corey Chapman, Auroris
Simpler default template to make NS happy - Corey Chapman
</mod info>

<edit file>
english.lng
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################
</replace>

<search for>
$englishlngver = "1 Gold - SP1";
</search for>

<replace>
$englishlngver = "1 Gold - SP 1.1";
</replace>

<search for>
$user_ip = ""; # Only change when IP's do not log. Several IP address environment variables are tested until a valid one is found.
</search for>

<add before>
$yycharset = "ISO-8859-15";
</add before>

<search for>
$txt{'93'} = "You are not to lock or unlock this topic; you must be a moderator or administrator to do that...";
</search for>

<replace>
$txt{'93'} = "You are not allowed to lock or unlock this topic; you must be a moderator or administrator to do this.";
</replace>

<search for>
$txt{'188'} = "Search by Forum";
</search for>

<replace>
</replace>

<search for>
$yycopyright = qq~<a href="$boardurl/YaBB.$yyext"><font size="1">$mbname</font></a> &#187; <font size="1">Powered by</font> <a href="http://yabb.xnull.com"><font size="1">YaBB 1 Gold - SP1</font></a><font size="1">!<BR>\nYaBB  2000-2001, </font><a href="http://www.xnull.com"><font size="1">Xnull</font></a><font size="1">. All Rights Reserved.</font>~;
</search for>

<replace>
$yycopyright = qq~<a href="$boardurl/YaBB.$yyext"><font size="1">$mbname</font></a> &#187; <font size="1">Powered by</font> <a href="http://www.yabbforum.com"><font size="1">YaBB $YaBBversion</font></a><font size="1">!<BR>\nYaBB  2000-2002, </font><a href="http://www.xnull.com"><font size="1">Xnull</font></a><font size="1">. All Rights Reserved.</font>~;
</replace>

<search for>
	$menusep = ' &#187; ';
</search for>

<replace>
	$menusep = ' <font size="1">&#005;</font>';
</replace>

<edit file>
YaBB.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

### Version Info ###
$YaBBversion = '1 Gold - SP1';
$YaBBplver = '1 Gold - SP1';
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

### Version Info ###
$YaBBversion = '1 Gold - SP 1.1';
$YaBBplver = '1 Gold - SP 1.1';
</replace>

<search for>
	if (!(($action eq 'login') || ($action eq 'login2') || ($action eq 'register') || ($action eq 'register2'))) { &KickGuest; }
</search for>

<replace>
	if(!(($action eq 'login') || ($action eq 'login2') || ($action eq 'register') || ($action eq 'register2') || ($action eq 'reminder') || ($action eq 'reminder2'))) { &KickGuest; }
</replace>

<edit file>
Sources/Admin.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$adminplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$adminplver = "1 Gold - SP 1.1";
</replace>

<search for>
        Cueppens, Jay Silverman and Gunther Meyer.
        <BR><BR><i><B>YaBB 1 Gold:</B></i> Corey Chapman, Darya Misse, Popeye, [CV]XXL, Dave Baughman,
        Dave G, Carey P, Christian Land, Tim Cueppens, ejdmoo, StarSaber, Parham and the rest for helping out with
</search for>

<replace>
        Ceuppens, Jay Silverman and Gunther Meyer.
        <BR><BR><i><B>YaBB 1 Gold:</B></i> Corey Chapman, Darya Misse, Popeye, Michael Prager, Dave Baughman,
        Dave G, Carey P, Christian Land, Tim Ceuppens, ejdmoo, StarSaber, Parham and the rest for helping out with
</replace>

<search for>
	print FILE qq~$membershiptotal|$lastvalidmember~;
	fclose(FILE);
</search for>

<add after>

	# For security, remove username from mod position
	fopen(FILE, "$vardir/cat.txt"); @categories = <FILE>; fclose(FILE);

	foreach $curcat (@categories) {
		$curcat =~ s/[\n\r]//g;
		fopen(CAT, "$boardsdir/$curcat.cat"); @catinfo = <CAT>; fclose(CAT);

		foreach $curboard (@catinfo) {
				$curboard =~ s/[\n\r]//g; chomp $curboard;

				fopen(BOARD, "$boardsdir/$curboard.dat"); @boardinfo = <BOARD>; fclose(BOARD);

				$boardinfo[2] =~ s/[\n\r]//g; $boardinfo[2] =~ /^\|(.*?)\|$/;
				$mods = $1 or $mods = $boardinfo[2];
				$mods =~ s/\|(\S?)/,$1/g;

				$mods_changed=0;
				if($currentmem && $mods =~ /(,*)$currentmem(,*)/g) {$mods =~ s~(,*)$currentmem(,*)~~; $mods_changed=1;}

				if ($mods_changed == 1)
				{
					$boardinfo[2] = $mods;
					fopen(BOARD, ">$boardsdir/$curboard.dat", 1);
					print BOARD @boardinfo;
					fclose(BOARD);
				}
		}
	}
</add after>

<edit file>
Sources/AdminEdit.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$admineditplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$admineditplver = "1 Gold - SP 1.1";
</replace>

<search for>
	fopen(FILE, "$vardir/news.txt");
	@newsitems = <FILE>;
	fclose(FILE);
	$yymain .= qq~
<form action="$cgi;action=editnews2" method="POST">
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
    <img src="$imagesdir/xx.gif" alt="">
    <font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'7'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><BR><font size="1">$txt{'670'}</font><BR><BR></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}" align="center"><BR>
    <font size=2>
    <textarea cols=70 rows=8 name="news">
~;
	foreach $curnews (@newsitems) {
		$curnews =~ s/[\n\r]//g;
		if( $curnews =~ m~\A\s*\Z~ ) { next; }
		$yymain .= "$curnews\n";
	}
</search for>

<replace>
	my($line);
	$yymain .= qq~
<form action="$cgi;action=editnews2" method="POST">
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}">
    <img src="$imagesdir/xx.gif" alt="">
    <font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'7'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><BR><font size="1">$txt{'670'}</font><BR><BR></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}" align="center"><BR>
    <font size=2>
    <textarea cols=70 rows=8 name="news">
~;
	fopen(FILE, "$vardir/news.txt");
	while($line = <FILE>) { $yymain .= qq~$line~; }
	fclose(FILE);
</replace>

<search for>
		$line =~ tr/[\r\n]//d;
</search for>

<replace>
		$line =~ s~[\r\n]~~g;
</replace>

<search for>
	$maintenancetext = $FORM{'maintenancetext'} || "";
</search for>

<add after>
	&ToHTML($maintenancetext);
</add after>

<search for>
	if($clicklogtime > 1440) { $clicklogtime = 1440; }
</search for>

<replace>
	if($clicklogtime >= 1440) { $clicklogtime = 1439; }
</replace>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
</replace>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$boardindexplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$boardindexplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/Display.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$displayplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$displayplver = "1 Gold - SP 1.1";
</replace>

<search for>
			@userprofile = @{$userprofile{$musername}};
</search for>

<add after>
			$displayname = $userprofile[1];
</add after>

<search for>
			@userprofile = ();
</search for>

<add after>
			$displayname = $mname;
</add after>

<search for>
	  $yymain .= qq~
  <tr>
    <td align="left" valign="top" colspan="2">~;
	if(exists $moderators{$username} || $settings[7] eq 'Administrator') {
		$yymain .= qq~<font size="1">
	<b>$img{'admin_func'}</b> &nbsp;<a href="$cgi;action=movethread;thread=$viewnum">$img{'admin_move'}</a>
	<a href="javascript:DoConfirm('$txt{'162'}','$cgi;action=removethread;thread=$viewnum')">$img{'admin_rem'}</a>
	<a href="$cgi;action=lock;thread=$viewnum">$img{'admin_lock'}</a>
	<a href="$cgi;action=sticky;thread=$viewnum">$img{'admin_sticky'}</a>
</font>~;
</search for>

<replace>
	  $yymain .= qq~
  <tr>
    <td align="left" valign="top" colspan="2">~;
	if(exists $moderators{$username} || $settings[7] eq 'Administrator') {
		$yymain .= qq~<font size="1"><b>$img{'admin_func'}</b>
        &nbsp;<a href="$cgi;action=movethread;thread=$viewnum">$img{'admin_move'}</a>$menusep
        <a href="javascript:DoConfirm('$txt{'162'}','$cgi;action=removethread;thread=$viewnum')">$img{'admin_rem'}</a>$menusep
        <a href="$cgi;action=lock;thread=$viewnum">$img{'admin_lock'}</a>$menusep
        <a href="$cgi;action=sticky;thread=$viewnum">$img{'admin_sticky'}</a>
</font>~;
</replace>

<search for>
            <td><font size="2"><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align="right" width="350"><font size="2">
</search for>

<replace>
            <td><font size="2"><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align="right"><font size="2">
</replace>

<search for>
            <td><font size=2><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align=right width="350"><font size=2>
</search for>

<replace>
            <td><font size=2><b>$txt{'139'}:</b> $pageindex</font></td>
            <td class="catbg" bgcolor="$color{'catbg'}" align=right><font size=2>
</replace>

<edit file>
Sources/ICQPager.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$icqpagerplver="1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$icqpagerplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/InstantMessage.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$instantmessageplver="1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$instantmessageplver = "1 Gold - SP 1.1";
</replace>

<search for>
			@userprofile = @{$userprofile{$musername}};
</search for>

<add after>
			$displayname = $userprofile[1];
</add after>

<search for>
		if (!$useraccount{$musername}) {$usernamelink=qq~<font size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>";}
</search for>

<replace>
		if (!$useraccount{$musername}) {$usernamelink=qq~<font  size="2"><B>$musername</B></font>~; $memberinfo ="<b>$txt{'783'}</b>"; $displayname = $musername;}
</replace>

<edit file>
Sources/Load.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$loadplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$loadplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/LockThread.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$lockthreadplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$lockthreadplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/LogInOut.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$loginoutplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$loginoutplver = "1 Gold - SP 1.1";
</replace>

<search for>
            <td valign="middle" align="left"><font size=2><input type=checkbox name="cookieneverexp" tabindex="4" checked>&nbsp;&nbsp;</font> <input type=submit value="$txt{'34'}" tabindex="5" accesskey="l"></font></td>
</search for>

<add after>
            <td valign="middle" align="left"><a href="$cgi;action=reminder"><font size="1">$txt{'315'}</font></a></td>
</add after>

<search for>
<BR><BR><table border=0 width=400 cellspacing=1 bgcolor="$color{'bgcolor'}" align="center">
</search for>

<replace>
<BR><BR><table border=0 width=400 cellspacing=1 bgcolor="$color{'bordercolor'}" align="center" class="bordercolor">
</replace>

<edit file>
Sources/Maintenance.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$maintenanceplver="1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$maintenanceplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/ManageBoards.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$manageboardsplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$manageboardsplver = "1 Gold - SP 1.1";
</replace>

<search for>
		$newcatlist="@categories[0]\n@categories[1]";
</search for>

<replace>
		chomp @categories;
		@categories[0] =~ s/\n//g;
		@categories[1] =~ s/\n//g;
		$newcatlist = "@categories[0]\n@categories[1]\n";
</replace>

<search for>
	$FORM{'boards'} =~ s/\r//g;
	$boards = $FORM{'boards'};
	(@boards) = split(/\n/, $boards);
	$FORM{'firstline'} =~ s/\n//g;
	$FORM{'secondline'} =~ s/\n//g;
</search for>

<replace>
	$FORM{'firstline'} =~ s/[\n\r]//g;
	$FORM{'secondline'} =~ s/[\n\r]//g;
	$FORM{'boards'} =~ s/\r//g;
	$boards = $FORM{'boards'};
	(@boards) = split(/\n/, $boards);
</replace>

<edit file>
Sources/ManageCats.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$managecatsplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$managecatsplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/Memberlist.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$memberlistplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$memberlistplver = "1 Gold - SP 1.1";
</replace>

<Search for>
sub MLByLetter {
</Search for>

<Add before>
sub case_insensitive {
  uc($::a) cmp uc ($::b);
}
</Add before>

<Search for>
		@ToShow = sort(@ToShow);
</Search for>

<replace>
		@ToShow = sort(case_insensitive(@ToShow));
</replace>

<edit file>
Sources/MessageIndex.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$messageindexplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$messageindexplver = "1 Gold - SP 1.1";
</replace>

<search for>
        <td class="titlebg" bgcolor="$color{'titlebg'}" width="27%"><font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'111'}</b></font></td>
</search for>

<add after>
      </tr>
</add after>

<search for>
	&MessageIndex;
</search for>

<replace>
	$yySetLocation = qq~$scripturl~;
	&redirectexit;
</replace>

<search for>
	    <td class="catbg" bgcolor="$color{'catbg'}" align=right width="400" nowrap><font size=-1>
</search for>

<replace>
	    <td class="catbg" bgcolor="$color{'catbg'}" align=right nowrap><font size=-1>
</replace>

<search for>
	    <td class="catbg" bgcolor="$color{'catbg'}" align=right width="400" nowrap><font size="2">
</search for>

<replace>
	    <td class="catbg" bgcolor="$color{'catbg'}" align=right nowrap><font size="2">
</replace>

<edit file>
Sources/ModifyMessage.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$modifymessageplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$modifymessageplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/MoveThread.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$movethreadplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$movethreadplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/Notify.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$notifyplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$notifyplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/Post.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$postplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$postplver = "1 Gold - SP 1.1";
</replace>

<search for>
			&wrap;
</search for>

<add after>
			$displayname = $tempname;
</add after>

<search for>
<table border=0 width="90%" cellspacing="2" cellpadding="0" bgcolor="$color{'bordercolor'}" align="center">
</search for>

<replace>
<table border=0 width="90%" cellspacing="1" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
</replace>

<edit file>
Sources/Printpage.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$printplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$printplver = "1 Gold - SP 1.1";
</replace>

<search for>
		$threadpost =~ s~\[size=(.+?)\](.+?)\[/size\]~<font size="$1">$2</font>~isg;
</search for>

<add after>

		$threadpost =~ s~\[quote\s+author=(.*?)\s+link=(.*?)\].*\/me\s+(.*?)\[\/quote\]~\[quote author=$1 link=$2\]<i>* $1 $3</i>\[/quote\]~isg;
		$threadpost =~  s~\[quote(.*?)\].*\/me\s+(.*?)\[\/quote\]~\[quote$1\]<i>* Me $2</i>\[/quote\]~isg;
		$threadpost =~ s~\/me\s+(.*)~<font color="#FF0000">* $displayname $1</font>~ig;
</add after>

<search for>
	print qq~
</search for>

<add before>
	print "Content-type: text/html\n\n";
</add before>

<search for>
		$threadpost =~ s~\[img\](.+?)\[/img\]~$1~isg;
		$threadpost =~ s~\[img width=(\d+) height=(\d+)\](.+?)\[/img\]~$3~eisg;
</search for>

<replace>
		$char_160 = chr(160);
		$threadpost =~ s~\[img\][\s*\t*\n*(&nbsp;)*($char_160)*]*(http\:\/\/)*(.+?)[\s*\t*\n*(&nbsp;)*($char_160)*]*\[/img\]~http://$2~isg;
		$threadpost =~ s~\[img width=(\d+) height=(\d+)\][\s*\t*\n*(&nbsp;)*($char_160)*]*(http\:\/\/)*(.+?)[\s*\t*\n*(&nbsp;)*($char_160)*]*\[/img\]~http://$4~isg;
</replace>

<edit file>
Sources/Profile.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$profileplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$profileplver = "1 Gold - SP 1.1";
</replace>

<search for>
		&wrap;
</search for>

<add after>
		$displayname = $mname;
</add after>

<search for>
	} else {
	if($member{'username'} ne "admin") {
</search for>

<add after>

	# For security, remove username from mod position
	fopen(FILE, "$vardir/cat.txt"); @categories = <FILE>; fclose(FILE);

	foreach $curcat (@categories) {
		$curcat =~ s/[\n\r]//g;
		fopen(CAT, "$boardsdir/$curcat.cat"); @catinfo = <CAT>; fclose(CAT);

		foreach $curboard (@catinfo) {
				$curboard =~ s/[\n\r]//g; chomp $curboard;

				fopen(BOARD, "$boardsdir/$curboard.dat"); @boardinfo = <BOARD>; fclose(BOARD);

				$boardinfo[2] =~ s/[\n\r]//g; $boardinfo[2] =~ /^\|(.*?)\|$/;
				$mods = $1 or $mods = $boardinfo[2];
				$mods =~ s/\|(\S?)/,$1/g;

				$mods_changed=0;
				if($settings[7] eq 'Administrator' && $mods =~ /(,*)$member{'username'}(,*)/g) {$mods =~ s~(,*)$member{'username'}(,*)~~; $mods_changed=1;}
				elsif($member{'username'} eq $username && $mods =~ /(,*)$username(,*)/g) {$mods =~ s~(,*)$username(,*)~~; $mods_changed=1;}

				if ($mods_changed == 1)
				{
					$boardinfo[2] = $mods;
					fopen(BOARD, ">$boardsdir/$curboard.dat", 1);
					print BOARD @boardinfo;
					fclose(BOARD);
				}
		}
	}
</add after>

<search for>
    <td width=75% bgcolor="$color{'titlebg'}"><font class="text1" color="$color{'titletext'}" size=2><b>&nbsp;$catname{$cat{$board}} / $boardinfo{$board}->[0] / <a href="$scripturl?board=$board;action=display;num=$tnum;start=$c"><font class="text1" color="$color{'titletext'}" size=2>$msub</font></a></b></font></td>
</search for>

<replace>
    <td width=75% bgcolor="$color{'titlebg'}"><font class="text1" color="$color{'titletext'}" size=2><b>&nbsp;$catname{$cat{$board}} / $boardinfo{$board}->[0] / <a href="$scripturl?board=$board;action=display;num=$tnum;start=$c"><font class="text1" color="$color{'titletext'}" size=2><u>$msub</u></font></a></b></font></td>
</replace>

<edit file>
Sources/Recent.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$recentplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$recentplver = "1 Gold - SP 1.1";
</replace>

<search for>
		if( $tusername ne 'Guest' ) {
</search for>

<add before>
		$displayname = $mname;
</add before>

<search for>
<table border=0 width=100% cellspacing=1 $color{'bordercolor'}>
</search for>

<replace>
<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
</replace>

<edit file>
Sources/Register.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$registerplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$registerplver = "1 Gold - SP 1.1";
</replace>

<search for>
        <td><font size=2><input type=text maxlength="40" name=email size=30> <input type="checkbox" name="hideemail" value="checked"> $txt{'721'}</font></td>
</search for>

<replace>
        <td><font size=2><input type=text maxlength="40" name=email size=30> <input type="checkbox" name="hideemail" value="checked" checked> $txt{'721'}</font></td>
</replace>

<edit file>
Sources/RemoveOldThreads.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$removeoldthreadsplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$removeoldthreadsplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/RemoveThread.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$removethreadplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$removethreadplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/Search.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$searchplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$searchplver = "1 Gold - SP 1.1";
</replace>

<search for>
        <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size=2><b>$txt{'189'}:</B></font></td>
</search for>

<replace>
        <td class="windowbg2" bgcolor="$color{'windowbg2'}" valign="top"><font size=2><b>$txt{'189'}:</B></font></td>
</replace>

<search for>
			$yymain .= qq~<td width="50%"><font size="2"><input type=checkbox name="brd$counter" value="$curboard" checked><span id="spanbrd$counter" style="cursor:hand;" onClick="changeBox('document.searchform.brd$counter')">$boardinfo[0]</span></font></td>~;
</search for>

<replace>
			$yymain .= qq~<td width="50%"><font size="2"><input type=checkbox name="brd$counter" value="$curboard" checked><span style="cursor:hand;" onClick="changeBox('document.searchform.brd$counter')">$boardinfo[0]</span></font></td>~;
</replace>

<search for>
            <td><font size="2"><input type=checkbox name=subfield value=on checked><span id="spansubfield" style="cursor:hand;" onClick="changeBox('document.searchform.subfield')">$txt{'70'}</span></font></td>
            <td><font size="2"><input type=checkbox name=msgfield value=on checked><span id="spanmsgfield" style="cursor:hand;" onClick="changeBox('document.searchform.msgfield')">$txt{'72'}</span></font></td>
</search for>

<replace>
            <td><font size="2"><input type=checkbox name=subfield value=on checked><span style="cursor:hand;" onClick="changeBox('document.searchform.subfield')">$txt{'70'}</span></font></td>
            <td><font size="2"><input type=checkbox name=msgfield value=on checked><span style="cursor:hand;" onClick="changeBox('document.searchform.msgfield')">$txt{'72'}</span></font></td>
</replace>

<search for>
		if( $tusername ne 'Guest' ) {
</search for>

<add before>
		$displayname = $mname;
</add before>

<search for>
<table border=0 width="80%" cellspacing="2" cellpadding="0" bgcolor="$color{'bordercolor'}" align="center">
</search for>

<replace>
<table border=0 width="80%" cellspacing="1" cellpadding="0" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
</replace>

<edit file>
Sources/Security.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$securityplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$securityplver = "1 Gold - SP 1.1";
</replace>

<edit file>
Sources/SendTopic.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$sendtopicplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$sendtopicplver = "1 Gold - SP 1.1";
</replace>

<search for>
	&sendmail($remail,"$txt{'118'}:  $subject ($txt{'318'} $yname)","$txt{'711'} $rname,\n\n$txt{'712'}: $subject, on $mbname. $txt{'713'}:\n\n$cgi;action=display;num=$topic\n\n\n$txt{'714'},\n$yname",$yemail);
</search for>

<replace>
	&sendmail($remail,"$txt{'118'}:  $subject ($txt{'318'} $yname)","$txt{'711'} $rname,\n\n$txt{'712'}: $subject, $txt{'30'} $mbname. $txt{'713'}:\n\n$cgi;action=display;num=$topic\n\n\n$txt{'714'},\n$yname",$yemail);
</replace>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$subsplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$subsplver = "1 Gold - SP 1.1";
</replace>

<search for>
	if($yySetCookies1 || $yySetCookies2) { print header(-cookie=>[$yySetCookies1, $yySetCookies2]); }
	else { print header(-status=>'200 OK'); }
</search for>

<replace>
	if($yySetCookies1 || $yySetCookies2) { print header(-cookie=>[$yySetCookies1, $yySetCookies2], -charset=>'$yycharset'); }
	else { print header(-status=>'200 OK', -charset=>'$yycharset'); }
</replace>

<search for>
sub calctime {  # Input: $date1 $date2
	my( $dummy, $times, $hour, $min, $sec, $number1, $number2 );
	($dummy, $times) = split(/ $txt{'107'} /, $date1);
	($hour, $min, $sec) = split(/\:/, $times);
	$number1 = ($hour*60)+$min+($sec/60);
	($dummy, $times) = split(/ $txt{'107'} /, $date2);
	($hour, $min, $sec) = split(/\:/, $times);
	$number2 = ($hour*60)+$min+($sec/60);
	$result = $number2-$number1;
}
</search for>

<replace>
sub calctime {  # Input: $date1 $date2
	my($dummy, $times, $hour, $min, $sec, $number1, $number2, $day1, $day2);
	($day1, $times) = split(/ $txt{'107'} /, $date1);
	($hour, $min, $sec) = split(/\:/, $times);
	$number1 = ($hour*60)+$min+($sec/60);
	($day2, $times) = split(/ $txt{'107'} /, $date2);
	($hour, $min, $sec) = split(/\:/, $times);
	$number2 = ($hour*60)+$min+($sec/60);
	# if days are different, increase second time by 1440 mins
	if ($day1 ne $day2) {$number2 = $number2+1440;} 
	$result = $number2-$number1;
}
</replace>

<search for>
		$date2 = $date;
		&calctime;
</search for>

<replace>
		$date2 = $date;
		chomp $date1;
		chomp $date2;
		&calctime;
</replace>

<search for>
	if ($flood) { &fatal_error("$txt{'409'} $timeout $txt{'410'}"); }
</search for>

<replace>
	if ($flood && $settings[7] ne 'Administrator') { &fatal_error("$txt{'409'} $timeout $txt{'410'}"); } 
</replace>

<search for>
			if( $ip eq $flood_ip && $time - $flood_time <= $timeout ) { $flood = 1; }
</search for>

<replace>
			if($user_ip eq $flood_ip && $time - $flood_time <= $timeout) { $flood = 1; }
</replace>

<search for>
		$date2 = $date;
		&calctime;
</search for>

<replace>
		$date2 = $date;
		chomp $date1;
		chomp $date2;
		&calctime;
</replace>

<search for>
		if($result <= $ClickLogTime && $results >= 0) { print LOG "$curentry\n"; }
</search for>

<replace>
		if($result <= $ClickLogTime && $result >= 0) { print LOG "$curentry\n"; }
</replace>

<search for>
		if($cur !~ m~\[url(\S*)\](\S*)\[\/url\]~ && $cur !~ m~\[flash(\S*)\](\S*)\[\/flash\]~) { $cur =~ s~\[(\S*)\](\S{72})(\S*)\[\/(\S*)\]~\[$1\]$2 $3\[/$4\]~g; }
</search for>

<replace>
		if($cur !~ m~\[url(\S*)\](\S*)\[\/url\]~ && $cur !~ m~\[flash(\S*)\](\S*)\[\/flash\]~ && $cur !~ m~\[img(\S*)\](\S*)\[\/img\]~) { $cur =~ s~\[(\S*)\](\S{72})(\S*)\[\/(\S*)\]~\[$1\]$2 $3\[/$4\]~g; }
</replace>

<edit file>
Sources/YaBBC.pl
</edit file>

<search for>
# Software Version: YaBB 1 Gold - SP1                                         #
# Released: December 2001                                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$yabbcplver = "1 Gold - SP1";
</search for>

<replace>
# Version:        YaBB 1 Gold - SP 1.1                                        #
# Released:       December 2001; Updated March 22, 2002                       #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2002 Xnull (www.xnull.com) - All Rights Reserved.        #
# Software by: The YaBB Development Team                                      #
#              with assistance from the YaBB community.                       #
###############################################################################

$yabbcplver = "1 Gold - SP 1.1";
</replace>

<search for>
sub quotemsg {
	my( $qauthor, $qlink, $qdate, $qmessage ) = @_;
</search for>

<add after>
	$qmessage =~ s~\/me\s+(.*?)(\n.*?)~<font color="#FF0000">* $qauthor $1</font>$2~ig;
	$qmessage =~ s~<font color="#FF0000">(.*?)\/me~<font color="#FF0000">$1\&\#47\;me~ig;
	$qmessage =~ s~\/me\s+([\s\S]*)~<font color="#FF0000">* $qauthor $1</font>~ig;
</add after>

<search for>
sub simplequotemsg {
	my $qmessage = $_[0];
</search for>

<add after>
	$qmessage =~ s~\/me\s+(.*?)(\n.*?)~<font color="#FF0000">* $1</font>~ig;
	$qmessage =~ s~<font color="#FF0000">(.*?)\/me~<font color="#FF0000">$1\&\#47\;me~ig;
	$qmessage =~ s~\/me\s+([\s\S]*)~<font color="#FF0000">* $1</font>~ig;
	$qmessage =~ s~\/me~\&\#47\;me~ig;
</add after>

<search for>
	$message =~ s~\/me\s(\S*)~<font color="red">* $1</font>~g;
</search for>

<replace>
</replace>

<search for>
	$message =~ s~\[quote\s+author=(.*?)link=(.*?)\s+date=(.*?)\s*\]\n*(.*?)\n*\[/quote\]~&quotemsg($1,$2,$3,$4)~eisg;
	$message =~ s~\[quote\]\n*(.+?)\n*\[/quote\]~&simplequotemsg($1)~eisg;
</search for>

<add after>

	$message =~ s~\/me\s+(.*)~<font color="#FF0000">* $displayname $1</font>~ig;

</add after>

<search for>
	$message =~ s~\[img\]\n?javascript\:(.+?)\n?\[/img\]~\[ img\]javascript\:$1\[/img \]~isg;
	if($message =~ m~\[img\]\n?(.+?)\n?\[/img\]~gi && $1 !~ m~javascript\:~gi) { $message =~ s~\[img\]\n?(.+?)\n?\[/img\]~<img src="$1" alt="" border="0">~isg; }
	$message =~ s~\[img width=(\d+) height=(\d+)\]\n?javascript\:(.+?)\n?\[/img\]~\[ img width=$1 height=$2\]javascript\:$3\[/img \]~isg;
	if($message =~ m~\[img width=(\d+) height=(\d+)\]\n?(.+?)\n?\[/img\]~gi && $3 !~ m~javascript\:~gi) { $message =~ s~\[img width=(\d+) height=(\d+)\]\n?(.+?)\n?\[/img\]~restrictimage($1,$2,$3)~eisg; }
</search for>

<replace>
	$char_160 = chr(160);
	$message =~ s~\[img\][\s*\t*\n*(&nbsp;)*($char_160)*]*(http\:\/\/)*(.+?)[\s*\t*\n*(&nbsp;)*($char_160)*]*\[/img\]~<img src="http\:\/\/$2" alt="" border="0">~isg;
	$message =~ s~\[img width=(\d+) height=(\d+)\][\s*\t*\n*(&nbsp;)*($char_160)*]*(http\:\/\/)*(.+?)[\s*\t*\n*(&nbsp;)*($char_160)*]*\[/img\]~restrictimage($1,$2,'http://'.$4)~eisg;
</replace>