#######################################################
# Newcalendar for SP1 mod by Ironwing and GauGau.	#
# Based on Event Calendar by Nermware			#
# Support: boardmod.yabbforums.com				#
# Version 3.9							#
#######################################################
# CalMain routine
# GetActType routine
# GetSelDate routine
# GetDBData routine
# SendTrailer routine
#####################################################
$Newcalendarplver = 'NewcalendarSP1 3.9';
# CalMain is the main calendar routine, called by YaBB.pl
sub CalMain {
	$rev = "1.3.1";						# This is the Nermware calendar ver num, must not change
	require "$vardir/newcalsettings.txt";		# This is the settings file

	chomp $newcalgroup;
	@newcalgrouplist = split(",",$newcalgroup);
	$newcalgroupflag = 0;
	foreach $newcalgroupitem (@newcalgrouplist) {
		if ($settings[7] eq $newcalgroupitem) { $newcalgroupflag = 1; }
	}
	if ($newcalopen == 1 || $settings[7] eq 'Administrator' || $newcalgroupflag == 1 ) {

		@sbjlist = split(" ",$sbjlist);			# Build event type list from settings file
		$yytitle = $ecaltxt{'109'};				# Set window title
		$dbfile = "$vardir/newcaldb.txt";			# This is the database file
		$origcom = qq~$ecaltxt{'58'}eventcalendar.pl v$rev$ecaltxt{'59'}~;   # Nermware credit must remain
		$adaptcom = 'Ironwing';					# Credit text
		use Time::Local;						# Loads perl time::local module
		$acttype = GetActType();				# Find out what the user wants to do
		@seldate = GetSelDate();				# Get the user specified date or the current date
		if ($acttype ne 'disyear') {
			$yeardbflag = 'dummy';				# Sets database read parameters for all reads but year view
			GetDbData();					# Read the database except for Year View Cal
		}
		if($acttype =~ /display/) {
			require "$sourcedir/NewcalMonth.pl";	# Load the Month View routines
			if ( ( $addbdays1 == 1 ) || ( @ncfieldmonsho) ) {
				CalBDay2();					# Birthday routine for month view
			}
			DisCalendar();					# Create the Month View Calendar
			DisCalForm();					# Create select month form at bottom of Month View
		}
		if($acttype =~ /disyear/) {
			require "$sourcedir/NewcalYear.pl";		# Load the Year View routines
			YearCal();						# Create the Year View Calendar
			DisYearForm();					# Create select year form at bottom of Year View
		}

		if($acttype =~ /enterdata/) {
			require "$sourcedir/NewcalEnter.pl";	# Load the Data Entry routines
			EnterData();					# Create the Edit Events Page
		}

		if($acttype =~ /editdata/) {
			require "$sourcedir/NewcalEnter.pl";	# Load the Data Entry routines
			EditData();					# Create the Edit Events Page
		}

		if($acttype =~ /viewdata/) {
			require "$sourcedir/NewcalView.pl";		# Load the View Events routines
			ViewData();						# Create the View Events Page
		}

		if($acttype =~ /search/) {
			require "$sourcedir/NewcalSearch.pl";	# Load the Calendar Search routines
			NewCalSearch() ;					# Create the Calendar Search Page
		}

 		if($acttype =~ /calsrch2/) {
			require "$sourcedir/NewcalSearch.pl";	# Load the Calendar Search routines
			NewCalSearch2();					# Create the Calendar Search Page
		}

		if(($acttype =~ /newdata/) || ($acttype =~ /deldata/)) {
			require "$sourcedir/NewcalEnter.pl";	# Load the DataEntry routines
			NewData();						# Write to the Calendar DataBase
			$acttype = display;				# Set action to month view after write
			$yeardbflag = 'dummy';
			GetDbData();
			require "$sourcedir/NewcalMonth.pl";	# Load the Month View routines
			if ($addbdays1 == 1) { 
				CalBDay2();
			}
			DisCalendar();
			DisCalForm();
		}
		SendTrailer();						# Adds trailer to all calendar pages
		&template;							# Sends the results back into YaBB
		exit;
	} else { &fatal_error($ecaltxt{'133'}); } # Error if user not authorized
} # end of routine
# GetActType determines type of action selected by user as passed by YaBB.pl
# This routine prevents abuse of INFO array by effectively filtering all INFO data.
# Called by CalMain, IndexCal, WhosCal, IncludeCal
sub GetActType {
	my($type) = "display";					# Sets default action to show month view
	$type = $INFO{'acttype'} if(defined($INFO{'acttype'}));
	$type = $FORM{'acttype'} if(defined($FORM{'acttype'}));
	$type = 'newdata' if(defined($FORM{'newdata'}));
	$type = 'deldata' if(defined($FORM{'deldata'}));
	return('display') if ($type =~ /display/);
	return('enterdata') if ($type =~ /enterdata/);
	return('editdata') if ($type =~ /editdata/);
	return('viewdata') if($type =~/viewdata/);
	return('newdata') if($type =~/newdata/);
	return('deldata') if($type =~/deldata/);
	return('search') if($type =~/search/);
	return('calsrch2') if($type =~/calsrch2/);
	return('disyear') if($type =~/disyear/);
	return('badtype');
}
# GetSelDate determines current time/date or selected time/date to display.
# Current time is based on YaBB user time settings.  Current time is used unless
# overridden by selected time.
# Called by CalMain, IndexCal, WhosCal, IncludeCal, and Newcalsearch2
sub GetSelDate {
	(my($selmonth),my($selday),my($selyear)) = (localtime(time + (3600*($timeoffset + $settings[18]))))[4,3,5];
	$selyear = $selyear+1900;
# Check both INFO and FORM strings for date info as both are used in different parts of script.
	$selmonth = $INFO{'selmonth'} if (defined($INFO{'selmonth'}));
	$selday = $INFO{'selday'} if (defined($INFO{'selday'}));
	$selyear = $INFO{'selyear'} if (defined($INFO{'selyear'}));

	$selmonth = $FORM{'selmonth'} if (defined($FORM{'selmonth'}));
	$selday = $FORM{'selday'} if (defined($FORM{'selday'}));
	$selyear = $FORM{'selyear'} if (defined($FORM{'selyear'}));

	return($selmonth,$selday,$selyear);
}
# GetDbData gets event data from database and builds recurring event data.
# Dates are stored using perl time indexing.  Index is number of seconds
# since the first of the year 1900.  The keys in dayinfo hash are time index numbers.
# Events are stored one date to a line with all events for that date on same line. 
# Called by CalMain, IndexCal, IncludeCal, WhosCal, and Newcalsearch2
sub GetDbData {
	%dayinfo = '';						# Initialize event hash
	$dropdeaddate = timegm(0,0,0,1,0,2037);		# Set last date allowed for all events to Jan 01, 2037 (on 32-bit servers perl time functions fail in 2038)
	if( $yeardbflag eq 'yearview' ) {
		$thismonth = $monthyear;			# Set data read parameters for Year View routine
		$thisyear = $yeardisyear;
		$nextmonth = $thismonth+1;
		$nextyear = $thisyear;
		if($nextmonth > 11) {
			$nextmonth = 0;
			$nextyear = $thisyear+1;
		}
	}
	if( $yeardbflag eq 'dummy' ) {
		$thismonth = $seldate[0];			# Set data read parameters for all other routines
		$thisyear = $seldate[2];
		$nextmonth = $thismonth+2;			# Set to two months so Upcoming Events lists can cross over to next calendar month.
		$nextyear = $thisyear;
		if($nextmonth = 11) {
			$nextmonth = 0;
			$nextyear = $thisyear+1;
		}
		if($nextmonth = 12) {
			$nextmonth = 1;
			$nextyear = $thisyear+1;
		}
	}
	my($selmonfst) = timegm(0,0,0,1,$thismonth,$thisyear);	# Time index of first of this month
	my($nxtmonfst) = timegm(0,0,0,1,$nextmonth,$nextyear);	# Time index of first of next month
	die("ERROR .. unable to open $dbfile\n") unless fopen(DBFILE,$dbfile);	# Read database file
	while ($strline=<DBFILE>) {
		chomp($strline);
		@line = split(/\|/,$strline);					# Split line into date index and event info.
		my($index) = shift(@line);					# Peel date index off of front of list.
		$dayinfo{$index} = [ @line ] if($index < $nxtmonfst); # dayinfo hash now has date indices as keys and events as values.
	}
	fclose(DBFILE);
	return if( ($acttype =~ /editdata/) || ($acttype =~ /enterdata/) || ($acttype =~ /newdata/) || ($acttype =~ /deldata/) || ($acttype =~ /badtype/) );	# Rest of this routine is for recurring events, not needed by routines listed here.
											# Start building new pseudo-indices for recurring events.
	my($daysecs) = 24*60*60;						# Seconds in a day
	my($weeksecs) = 168*60*60;						# Seconds in a week
	my(@dayinfokeys) = keys(%dayinfo);					# Build list of dates for which events exist.
											# Start loop of dates for which events exist
	foreach $index (@dayinfokeys) {
		my($element) = "";
		my(@entry) = ();
		foreach $element (@{ $dayinfo{$index} }) {
			my(@entry) = split('{',$element);			# For each date, separate individual events out of string holding all events for that date.
			my($repeatfor) = $entry[$#entry];			# Find out if event is to repeat (recur).  Rest of routine is only run for recurring events.
			if($repeatfor > 1) {
#### Add initial date to message, separated by   get back later
				$entry[2] .= qq~$index~;
#### End initial date addon
				my($newindex) = $index;				# Create pseudo-index for event.
				$addsecs = $daysecs if($entry[$#entry-1] =~ /$ecaltxt{'43'}/);	# Set number of seconds to add to pseudo-index for events which repeat daily.
				$addsecs = $weeksecs if($entry[$#entry-1] =~ /$ecaltxt{'44'}/);	# Set number of seconds to add to pseudo-index for events which repeat weekly.
				if(($entry[$#entry-1] =~ /$ecaltxt{'43'}/) || ($entry[$#entry-1] =~ /$ecaltxt{'44'}/)) {
												# Loop for number of repeats specified.
					for($i=2;$i<=$repeatfor;$i++) {
						$newindex = $newindex + $addsecs;		# Add seconds to pseudo-index for events recurring daily or weekly.
						next if( $newindex > $dropdeaddate );	# Ignore any repeats that would occur after drop dead date
						$entry[$#entry] = 0;				# Set repeats to zero for newly created psuedo-event, prevents run away repeating of psuedo-events.
						${$dayinfo{$newindex}}[++$#{$dayinfo{$newindex}}] = join('{',@entry) if(($newindex < $nxtmonfst) && ($newindex >= $selmonfst));	# Create new dayinfo hash element for pseudo-event.
					}
					next;
				} # End loop for daily and weekly type recurring events
				my($addyears) = my($addmonths) = 0;
				$addyears = 1 if($entry[$#entry-1] =~ /$ecaltxt{'46'}/);	# Set number of years to add to events which recur annually.
				$addmonths = 1 if($entry[$#entry-1] =~ /$ecaltxt{'45'}/);	# Set number of months to add to events which recur monthly.

				my(@thisdate) = gmtime($index);					# Get date array for original event index
				$addmonths = 1 if($entry[$#entry-1] =~ /$ecaltxt{'46a'}/);	# Set number of months to add to events which recur on 3rd Tuesday basis.
				$addyears = 1 if($entry[$#entry-1] =~ /$ecaltxt{'42'}/);	# Set number of years to add to events which recur on 2nd Sunday in May basis.
				my ($dayofweek) = $thisdate[6];					# Get day of week for original event date.
				my ($weekofmonth) = int( ($thisdate[3] - 1) / 7 );		# Calculate week of month for original event date.
				splice(@thisdate,-1,3);
														# Loop for number of repeats specified.
				for($i=2;$i<=$entry[$#entry];$i++) {
					$thisdate[4] = $thisdate[4] + $addmonths;			# Add months to pseudo-index.
					$thisdate[5] = $thisdate[5] + $addyears;			# Add years to pseudo-index.
					if($thisdate[4] > 11) {
						$thisdate[4]=0;						# Roll over year if needed
						$thisdate[5]++;						# Roll over year if needed
					}
														# Find day of week of first day of new month
					$tstring = timegm(0,0,0,1,$thisdate[4],$thisdate[5]);	# Get time index of first day of month for pseudo-date
					my (@newmonth1st) = gmtime($tstring);			# Get date array of first day of month for pseudo-date
					my ($wdaynewmonth1st) = $newmonth1st[6];			# Get weekday of first day of month of pseudo-date
					if ( ( $entry[$#entry-1] =~ /$ecaltxt{'46a'}/ ) || ( $entry[$#entry-1] =~ /$ecaltxt{'42'}/ ) ) {
						if ( $wdaynewmonth1st <= $dayofweek ) {
							$thisdate[3] = ( $weekofmonth * 7 ) + 1 + $dayofweek - $wdaynewmonth1st;	# Calculate day-of-month for pseudo-date when first of month is earlier in week then pseudo-date
						} else {
							$thisdate[3] = ( $weekofmonth * 7 ) + 8 + $dayofweek - $wdaynewmonth1st;	# Calculate day-of-month for pseudo-date when first of month is later in week then pseudo-date
						}
					}
					$newindex = timegm(@thisdate);				# Get date index for pseudo-date
					next if( $newindex > $dropdeaddate );		# Ignore any repeats that would occur after drop dead date
					if ( ( $entry[$#entry-1] =~ /$ecaltxt{'46a'}/ ) || ( $entry[$#entry-1] =~ /$ecaltxt{'42'}/ ) ) {
						$testindexflag = 1;
						my (@testindex) = gmtime($newindex);		# Test if new date is in same month
						if ( $testindex[4] != $thisdate[4] ) {
							$testindexflag = 0;
						}
						${$dayinfo{$newindex}}[++$#{$dayinfo{$newindex}}] = join('{',@entry) if( ($newindex < $nxtmonfst) && ($newindex >= $selmonfst) && ($testindexflag == 1) );	# Add new pseudo-event to dayinfo hash if in same month for events recurring 3rdTuesday and 2ndSunMay
					} else {
						${$dayinfo{$newindex}}[++$#{$dayinfo{$newindex}}] = join('{',@entry) if( ($newindex < $nxtmonfst) && ($newindex >= $selmonfst) );	# Add new pseudo-event to dayinfo hash if in same month for annual and monthly events
					}
				} # End loop for annual, monthly, 3ndTues, and 2ndSunMay type recurring events
			} # End loop for all recurring events
		} # End loop for events for date
	} # End loop through dayinfo hash
}
# SendTrailer puts footer at bottom of all calendar pages.
# Nermware credit must be shown on all calendar pages.
sub SendTrailer {
	my $helpfile2 = $helpfile;
	$helpfile2 =~ m/(.+)(\/.+$)/;
	my $newcalhelpfile = $1 . qq~/NewcalendarHelp.html~;
	$yymain .= qq~
<BR>
<CENTER>
  <A HREF="$scripturl?action=newcalendar&acttype=search"><SPAN class=newcal21>$ecaltxt{'89'}</SPAN></A>~;
	if( $settings[7] eq 'Administrator' ) {
		$yymain .= qq~&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="$cgi;action=newcalset" target=_blank><SPAN class=newcal21>$ecaltxt{'60'}</SPAN></A>~;
	}
	if ($newcalhelp == 1) {
		$yymain .= qq~&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="$newcalhelpfile" target=_blank><SPAN class=newcal21>$ecaltxt{'96'}</SPAN></A>~;
	}
	$yymain .= qq~

</CENTER>
	~;
}
1;