$YaBBChatplver = '1.98a for YaBB Gold SP1';
#########################################
# Main script for Chatroom
sub yabbchat {
	require "$vardir/ChatSettings.txt";

# load cookie #
	foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {
		$_ =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
 		($cookie,$value) = split(/=/);
		$yyCookies{$cookie} = $value;
	}
	if( $yyCookies{$cookiepassword} ) {
		$password = $yyCookies{$cookiepassword};
		$username = $yyCookies{$cookieusername} || 'Guest';
	} else {

		$username = 'Guest';
	} 
# get displayname #
	if ($username ne 'Guest'){
		fopen(FILE, "$memberdir/$username.dat");
		@settings = <FILE>;
		fclose(FILE);
		$username =~ s/\n//g;
		$userdisplayname = $settings[1];
		$userdisplayname =~ s/\n//g;
		$position = $settings[7];
		$position =~ s/\n//g;
		$usertimeoffset = $settings[18];
	} else {
		$userdisplayname = 'Guest';
		$position = 'Guest';
		$usertimeoffset = '0';
		}
	chomp $chatgroup;
	@chatgrouplist = split(",",$chatgroup);
	$chatgroupflag = 0;
	foreach $chatgroupitem (@chatgrouplist) {
		if ($position eq $chatgroupitem) { $chatgroupflag = 1; }
	}
	if (($chatopen eq '0') && ( $chatgroupflag != 1 ) && ($position ne "Administrator")) {
		&error($txt{'1'});
		exit;
		}
# set levels #
	$userlevel =1;

	chomp $level1;
	@levellist = split(",",$level1);
	$levelflag = 0;
	foreach $levelitem (@levellist) {
		if ($position eq $levelitem) { $levelflag = 1; }
	}
	if ($levelflag == 1) { $userlevel = 1; }

	chomp $level2;
	@levellist = split(",",$level2);
	$levelflag = 0;
	foreach $levelitem (@levellist) {
		if ($position eq $levelitem) { $levelflag = 1; }
	}
	if ($levelflag == 1) { $userlevel = 2; }

	chomp $level3;
	@levellist = split(",",$level3);
	$levelflag = 0;
	foreach $levelitem (@levellist) {
		if ($position eq $levelitem) { $levelflag = 1; }
	}
	if ($levelflag == 1) { $userlevel = 3; }
	if ( $position eq 'Administrator' ) {
		$userlevel = 3;
	}

# set variables #
	$cgiurl     = "$boardurl/YaBB.$yyext?action=chatnow";
	$logouturl  = "$imagesdir/close.htm";          
	$kickouturl = "$imagesdir/close.htm";
	$onlinefile    = "$vardir/online.txt"; 
	$messfile      = "$vardir/says.txt";
	$wordcolorfile = "$vardir/ecolor.txt";
#	$addsaysfile   = "$vardir/eaddsays.txt";
	my $faderpath2 = $faderpath;
	$faderpath2 =~ m/(.+)(\/.+$)/;
	$chatfaderpath = $1 . qq~/ubbc_for_chat_1_98.js~;

	$txt{'img1'} = "<img src=\"$imagesdir/refresh.gif\" width=\"15\" height=\"15\" border =\"0\">&nbsp;$chadmtxt{'60'}";
	$txt{'img2'} = "<img src=\"$imagesdir/buddy.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'31'}";
	$txt{'img3'} = "<img src=\"$imagesdir/info.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'55'}";
	$txt{'img4'} = "<img src=\"$imagesdir/pencil.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'56'}";
	$txt{'img5'} = "<img src=\"$imagesdir/kick.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'57'}";
	$txt{'img6'} = "<br><img src=\"$imagesdir/logout2.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'58'}";
	$txt{'img7'} = "<img src=\"$imagesdir/target.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;$chadmtxt{'37'}";
#	$txt{'img8'} = "<img src=\"$imagesdir/home.gif\" width=\"16\" height=\"16\" border =\"0\">&nbsp;Forum";

	$saysback   = $color{'chatsaysback'}; 
	$saysword   = $color{'chatsaysword'}; 
	$loginword  = $color{'chatloginword'}; 
	$logoutword = $color{'chatlogoutword'}; 
	$onlineback = $color{'chatonlineback'}; 
	$onlineword = $color{'chatonlineword'}; 
	$typeback   = $color{'chattypeback'}; 
	$typeword   = $color{'chattypeword'};
	$typefrmback= $color{'chattypefrmback'}; 
	$funcback   = $color{'chatfuncback'}; 
	$funcword   = $color{'chatfuncword'}; 
	$fastback   = $color{'chatfastback'};
	$sysmess    = $color{'chatsysmess'};
	$link	    = $color{'chatlink'};

	$reload   = $chatreload;
	$picsize      = 3;
	$kicktime     = $chatkicktime; 
	$allow_mess   = $chat_allow_mess;
	$show_time    = $chattimeshow;
	$show_top     = $chattopshow;
	$use_pics     = $chatpicshow;

	$level_towho     = 1;
	$level_cls	     = 2;
	$level_kick      = 3;

###############
	$title = "$mbname $chadmtxt{'0'}"; 
	print "Content-type: text/html;CHARSET=$yycharset\n";
	print "Pragma:no-cache\n\n";
	$kicked     = 0;
	$kickoutway ="level1";
	$exist="no";
	$|=1; 
	&set_var;
	if ($job eq "login") {
		&write_online("online");
		&write_mess("login") if ($exist eq "no");
		&return_whole;
	}
	elsif ($job eq "logout") {
		&write_online("outline");
		&write_mess("logout") if ($exist ne "no");
		&return_logout;
	}
	elsif ($job eq "setfunc") {
		&return_func;
	}
	elsif ($job eq "settype") {
		&write_online("online");
		&return_type;
	}
	elsif ($job eq "look") {
		&write_online("online");
		&return_mess;
	}
	elsif ($job eq "setup") {
		&return_up;
	}
	elsif ($job eq "tell") {
		&return_tell;
	}
	elsif ($job eq "says") {
		&write_online("online");
		if ($kicked!=1) {
 			&write_mess("says");
		}
		&return_mess;
	}
	elsif ($job eq "online") {
		&write_online("online");
		&return_online("online");
	}
	elsif ($job eq "setkick") {
		if ($userlevel>=$level_kick) {
			&write_online("online");
			&return_online("kickout");
		}
		else {
			&error("No User Right");
		}
	}
	elsif ($job eq "kickout") {
		if ($userlevel>=$level_kick) {
			if ($kickoutuser) {
 				&write_online("kickout");
			}  
			&return_mess;     
		}
		else {
			&error("No User Right");
		}
	}
	elsif ($job eq "typecls") {
		&return_cls;
		&write_mess("setcls");
		&return_mess;
	}
	exit;
}
# end of main script ####################
#########################################
# Writes new chat messages to says.txt file
sub write_mess {
	$write_mess_subject=$_[0];
	fopen(MESS,"$messfile") || die $!;
	@mess = <MESS>;
	fclose(MESS);
	fopen(MESS,">$messfile") || die $!;
	$total_mess1=0;
	$total_mess2=0;
	$sizeofmessarray = @mess;
	if ($sizeofmessarray >= $allow_mess) {
		$deadzone = shift @mess;
	}
	foreach $message (@mess) {
	($mark,$chkusername,$chkuserdisplayname,$chkuserlevel,$chktowhoway,$chktowhoname,$chkwordcolor,$chksays,$chktime,$markend,$last) = split(//, $message);
		if ($markend eq "end") {
			if ($mark eq "says") {
				if ($chktowhoway eq "private") {
					if (($total_mess2<$allow_mess) && ($total_mess1<$allow_mess)) {print MESS "$message";}
					$total_mess2++;}
         			else {
					if ($total_mess1<$allow_mess) {print MESS "$message";}
					$total_mess1++;}
			}
 			elsif (($mark eq "login") || ($mark eq "logout") || ($mark eq "setcls")) {
				if ($total_mess1<$allow_mess) {print MESS "$message";}
				$total_mess1++;}
		}
	}
	if ($write_mess_subject eq "login") {
		print MESS "login$username$userdisplayname$userlevel$normal_timeend\n"; 
		$total_mess1++;}
	elsif ($write_mess_subject eq "logout") {
		print MESS "logout$username$userdisplayname$userlevel$normal_timeend\n"; 
		$total_mess1++;}
	elsif ($write_mess_subject eq "setcls") {
		print MESS "setcls$username$userdisplayname$userlevel$normal_timeend\n"; 
		$total_mess1++;}
	elsif ($write_mess_subject eq "says") {
		$says =~ s/\/me\s+(.*)/\[color=red\]\*$userdisplayname $1\[\/color\]/ig;
##### start shortcuts addon
		if( $chatshortcutslist ) {
			@chatshortcuts = split( /\/, $chatshortcutslist );
			foreach $chatshortcut (@chatshortcuts) {
				chomp $chatshortcut;
				( $chatshortcut1, $chatshortcut2 ) = split( /\|/, $chatshortcut );

				if ( $says =~ /\/$chatshortcut1/ ) { $says = qq~$chatshortcut2~; }
			}
			if ( $says =~ /\/$chadmtxt{'87'}/ ) {
				$says = qq~*chatbreak*$chadmtxt{'88'}*chatbreak*~;
				foreach $chatshortcut (@chatshortcuts) {
					chomp $chatshortcut;
					( $chatshortcut1, $chatshortcut2 ) = split( /\|/, $chatshortcut );
					$says .= qq~\/$chatshortcut1=$chatshortcut2*chatbreak*~;
				}
			}	
		}
##### end shortcuts addon
##### start help addon
		if ( $says =~ /\/$chadmtxt{'53'}/ ) {
			my $helpfile2 = $helpfile;
			$helpfile2 =~ m/(.+)(\/.+$)/;
			my $chathelpfile = $1 . qq~/YaBBChatHelp.html~;
			$says = qq~[url=$chathelpfile]$chadmtxt{'59'} [\/url]~;
		}
##### end help addon
##### start admin center link addon
		if ( $says =~ /\/$chadmtxt{'40'}/ ) {
			if ( $position eq "Administrator" ) {
				$towhoway = "private";
				$chktowhoway = "private";
				$chktowhoname = $username;
				$towho = $username;
				$chkusername = $username;
				$says = qq~[url=$cgi\&action=chatset1]$chadmtxt{'6'} [\/url]~;
			} else {
				$says = qq~ :) ~;
			}
		}
##### end admin center link addon
		print MESS "says$username$userdisplayname$userlevel$towhoway$towho$wordcolor$says$normal_timeend\n"; 
		if (($towhoway eq "private") && ($towho ne "toall")) {$total_mess2++;}
		else {$total_mess1++;}
	}
	fclose(MESS);
}
#########################################
# Writes who is chatting to online.txt file
sub write_online {
	$write_online_subject = $_[0];
	fopen(ONLINE,"$onlinefile") || die $!;
	@online = <ONLINE>;
	fclose(ONLINE);
	@online    = sort @online;
	$lastcheck = "";
	$done      = 0;
	fopen(ONLINE,">$onlinefile") || die $!;
	foreach $online_line (@online) {   
		($mark,$chkusername,$chkuserip,$chkuserdisplayname,$chkuserlevel,$chktime,$chksec,$chkkickout,$chkkickoutway,$markend,$last)=split(//,$online_line);
		if (($mark eq "online") && ($markend eq "end")) {
			if ($lastcheck ne "$chkusername") {
				if (($write_online_subject eq "online") && ($chkusername eq $username)) {
					print ONLINE "online$username$user_ip$userdisplayname$userlevel$normal_time$now_sec$chkkickout$chkkickoutwayend\n"; 
					if ($chkkickout eq "kickouted") {
						$kicked    =1;
						$kickoutway=$chkkickoutway; 
					}
					$done=1;   
				}  
				elsif (($write_online_subject eq "outline") && ($chkusername eq $username) && ($chkkickout ne "kickouted")) {
					print ONLINE "";
					$exist="yes";
				}
				elsif (($write_online_subject eq "kickout") && ($kickoutuser eq "$chkusername")) {
					print ONLINE "online$kickoutuser$normal_time$now_seckickouted$kickoutwayend\n"; 
					$done=1;
 				}
				else { 
					if ((($chksec<$cut1_sec) || ($chksec>$cut2_sec)) && ($chkkickout ne "kickouted")) {
						print ONLINE ""; 
					} 
					elsif ((($chksec<$cut3_sec) || ($chksec>$cut4_sec)) && ($chkkickout eq "kickouted")) {
						print ONLINE ""; 
					} 
					else {
						print ONLINE "$online_line";
					}
				} 
			}
			$lastcheck = "$chkusername";  
		}
	}
	if (($write_online_subject eq "online") && ($done==0)) {
		print ONLINE "online$username$user_ip$userdisplayname$userlevel$normal_time$now_secend\n"; 
	}
	elsif (($write_online_subject eq "kickout") && ($done==0)) {
		print ONLINE "online$kickoutuser$normal_time$now_seckickouted$kickoutwayend\n"; 
	}
	fclose(ONLINE);
}
#########################################
# Reads says.txt and displays chat messages in main frame of Chatroom window
sub return_mess {
	require "$sourcedir/YaBBC.pl"; 
	fopen(MESS,"$messfile") || die $!;
	@mess = <MESS>;
	fclose(MESS);
	if ($kicked==1) {
		print "<html><head><title>$title</title>\n";
		print "<META HTTP-EQUIV=REFRESH CONTENT=\"0;URL=$kickouturl\"></head>\n";
		print "<body>\n";
		print "</body></html>\n"; 
	}
	else {
		print "<html><head><title>Chatting Screen</title>\n";
		print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=win\">\n";
		print "<META HTTP-EQUIV=REFRESH CONTENT=\"$reload;URL=$cgiurl\&job=look$userinfo\">\n";
		print qq~
			<SCRIPT LANGUAGE="JavaScript">
			<!--
			function ChatScroll() {
				window.scrollTo(0,10000);
				setTimeout('ChatScroll()',500); // scrolls every 500 miliseconds
				}
			setTimeout('ChatScroll()',100);
			//-->
			</SCRIPT>
		~;
		print "</head>\n";
		print "<body bgcolor=$color{'chat_bgcolor'} text=$saysword>\n";
		print "<font face=Arial, Helvetica, sans-serif>\n";
		print "<font size=2>\n";
		foreach $message (@mess) {
			$message =~ s~\[([^\]]{0,30})\n([^\]]{0,30})\]~\[$1$2\]~g;
			$message =~ s~\[/([^\]]{0,30})\n([^\]]{0,30})\]~\[/$1$2\]~g;
			$message =~ s~(\w+://[^<>\s\n\"\]\[]+)\n([^<>\s\n\"\]\[]+)~$1$2~g;
			$message =~ s/\&/\&amp;/g;
			$message =~ s/"/\&quot;/g;
			$message =~ s/  / \&nbsp;/g;
			$message =~ s/</\&lt;/g;
			$message =~ s/>/\&gt;/g;
			&LoadCensorList;
			foreach (@censored) {
				($tmpa,$tmpb) = @{$_};
				$message =~ s~\Q$tmpa\E~$tmpb~gi;
			}
			&DoUBBC;
#			print $message;
			($mark,$chkusername,$chkuserdisplayname,$chkuserlevel,$chktowhoway,$chktowhoname,$chkwordcolor,$chksays,$chktime,$markend,$last) = split(//, $message);
#			if ($markend ne "end") { &error("$message malformed"); exit;}
			$chksays =~ s~\*chatbreak\*~<br>~ig;
			$linebreak="<br>";
			if ($usertimeoffset ne '0') {
				($hour,$minute,$second)=split(/\:/,$chktime);
			 	$offhour=$hour + $usertimeoffset;
				if ($offhour >= 24) {
					$offhour=$offhour-24;
				}
				if ($offhour < 10) {
					$offhour="0$offhour";
				}
				$chktime="$offhour\:$minute\:$second";
				}
			if ($mark eq "says") {
				if ($chktowhoname eq "toall") {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<b>$chkuserdisplayname</b>: <font color=$chkwordcolor>$chksays</font>$linebreak\n";}
				elsif (($chktowhoname ne "toall") && ($chktowhoway eq "public")) {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<b>$chkuserdisplayname</b> $txt{'311'} <b>$chktowhoname</b>: <font color=$chkwordcolor>$chksays</font>$linebreak\n";}
 				elsif (($chktowhoname ne "toall") && ($chktowhoway eq "private") && (($username eq $chkusername) || ($userdisplayname eq $chktowhoname))) {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<b>$chkuserdisplayname</b> $chadmtxt{'49'} <b>$chktowhoname</b>: <font color=$chkwordcolor>$chksays</font>$linebreak\n";}
				}
			elsif ($mark eq "setcls") {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<font color=$sysmess>$chadmtxt{'48'}: $chkuserdisplayname $chadmtxt{'52'}</font>$linebreak\n";}
			elsif ($mark eq "login") {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<font color=$sysmess>$chadmtxt{'48'}: $chkuserdisplayname $chadmtxt{'50'}</font>$linebreak\n";}
			elsif ($mark eq "logout") {
					if ($show_time eq "1") {print "<font size=1>$chktime</font> ";}
					print "<font color=$sysmess>$chadmtxt{'48'}: $chkuserdisplayname $chadmtxt{'51'}</font>$linebreak\n";}
			}
		
		print "</font></font></body></html>\n";
	}
}
#########################################
# Display form across bottom of Chatroom window (text box, colors, emotions, public/private)
sub return_type {
	fopen(ONLINE,"$onlinefile") || die $!;
	@online = <ONLINE>;
	fclose(ONLINE);
	@online = sort @online;
	fopen(WORDCOLOR,"$wordcolorfile") || die $!;
	@wordcolor = <WORDCOLOR>;
	fclose(WORDCOLOR);
#	fopen(ADDSAYS,"$addsaysfile") || die $!;
#	@addsays = <ADDSAYS>;
#	fclose(ADDSAYS);
	print "<html><head>\n";
	print "<title>Typing Area</title>\n";
	print "<script Language=\"JavaScript\">\n";
	print "<!-- \n";
	print "function chksays() {\n";
	print "   var tt=chkempty(document\.forms[0]\.says\.value);\n";
	print "   if (tt==false) {\n";
	print "      alert(\"Nothing to send! Write something in the box first...\");\n";
	print "      return tt;\n";
	print "   }\n";
	print "   self.status=\"Data Sent\";\n";
	print "   return true;\n";
	print "}\n\n";
	print "function chkempty(txtval){\n";
	print "  if (txtval\.length==0)\n"; 
	print "     return false;\n";
	print "  var i=0;\n";
	print "  while (i<txtval\.length) {\n";    
	print "     if (txtval\.substring(i,i+1) !=\" \")\n"; 
	print "        return true;\n";
	print "     i=i+1;\n";
	print "   }\n";
	print "  return false;\n";
	print "}\n";
	print "//-->\n";
	print "</script>\n";
	print "<STYLE TYPE=\"text/css\"><!--\n";
	print "body	 {font-size: 9pt;}\n";
	print "td	 {font-size: 9pt;}\n";
	print "input     {font-size: 9pt;}\n";
	print "select    {font-size: 9pt;}\n";
	print "button    {font-size: 9pt;}\n";
	print "a:visited {text-decoration: none;}\n";
	print "--></STYLE>\n";
print qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if ((navigator.appVersion.substring(0,1) == "5" && navigator.userAgent.indexOf('Gecko') != -1) || navigator.userAgent.search(/Opera/) != -1) {
   document.write('<META HTTP-EQUIV="pragma" CONTENT="no-cache">');
}
// -->
</script>
~;
	print "</head>\n";
	print "<body bgcolor=$typeback text=$typeword>\n";
	print "<font face=Arial, Helvetica, sans-serif>\n";
	print "<font size=1>\n";
	print "<center>\n";
	print qq~<form method=POST action=\"$cgiurl\&job=says$userinfo\" target=\"one\" onsubmit=\"this.says.focus();this.says.select();return(chksays())\" name="postmodify" onSubmit="return submitproc()">\n~;
### smilie
print qq~
<script language="JavaScript1.2" src="$chatfaderpath" type="text/javascript"></script>
<script language="JavaScript1.2" type="text/javascript">
<!--
function showimage() {
   document.images.icons.src="$imagesdir/"+document.postmodify.icon.options[document.postmodify.icon.selectedIndex].value+".gif";
}
//-->
</script>
~;
### end smilie
### smilie
	print qq~<input type=text name="says" size="70" MAXLENGTH=$chatlength ONCLICK="javascript:storeCaret(this);" ONKEYUP="javascript:storeCaret(this);" ONCHANGE="javascript:storeCaret(this);" onMouseOver="this.focus()" tabindex="4"><br>~;
	print qq~$chadmtxt{'47'}<select name="wordcolor" style="background-color:$saysback">~;
	foreach $wordcolor_line (@wordcolor) {
		print qq~$wordcolor_line~;
	}
	print qq~</select>~;
	print qq~$chadmtxt{'44'}:<select name="towhoway" style="background-color:$typefrmback">~;
	print qq~<option value="public" selected>$chadmtxt{'45'}~;
	print qq~<option value="private">$chadmtxt{'46'}~;
	print qq~</select>~; 
	print qq~$chadmtxt{'42'}:<select name="towho" style="background-color:$typefrmback">~;
	print qq~<option value="toall">$chadmtxt{'43'}~;
	$lastcheck="";
	foreach $online_line (@online) {
		
	($mark,$chkusername,$chkuserip,$chkuserdisplayname,$userlevel,$chktime,$chksec,$chkkickout,$chkkickoutway,$markend,$last) = split(//, $online_line);
		if (($mark eq "online") && ($markend eq "end")) { 
			if ($chkusername ne $username) {
				if ($lastcheck ne $chkusername) {
					if (!(($chkkickout eq "kickouted") && ($userlevel<$level_kick))) {   
						if ($chkusername eq 'Guest'){
							$chkuserdisplayname = 'Guest';
						}			
						print "<option value=\"$chkuserdisplayname\">$chkuserdisplayname\n";
					} 
				}
				$lastcheck = "$chkusername";
			}
		} 
	}
	print "</select>\n";
#	print "$chadmtxt{'38'}:<select name=\"addsays\" style=\"background-color:$typefrmback;\">\n";
#	print "<option value=\"\">$chadmtxt{'39'}\n";
#	foreach $addsays_line (@addsays) {
#		print "$addsays_line";
#	} 
#	print "</select>\n";
#### Smilie stuff
if ( $chatsmilieline == 1) {
print qq~<br>
        <script language="JavaScript1.2" type="text/javascript">
        <!--
        if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
          document.write("<a href=javascript:smiley()><img src='$imagesdir/smiley.gif' align=bottom alt='$txt{'287'}' border='0'></a> ");
          document.write("<a href=javascript:wink()><img src='$imagesdir/wink.gif' align=bottom alt='$txt{'292'}' border='0'></a> ");
          document.write("<a href=javascript:cheesy()><img src='$imagesdir/cheesy.gif' align=bottom alt='$txt{'289'}' border='0'></a> ");
          document.write("<a href=javascript:grin()><img src='$imagesdir/grin.gif' align=bottom alt='$txt{'293'}' border='0'></a> ");
          document.write("<a href=javascript:angry()><img src='$imagesdir/angry.gif' align=bottom alt='$txt{'288'}' border='0'></a> ");
          document.write("<a href=javascript:sad()><img src='$imagesdir/sad.gif' align=bottom alt='$txt{'291'}' border='0'></a> ");
          document.write("<a href=javascript:shocked()><img src='$imagesdir/shocked.gif' align=bottom alt='$txt{'294'}' border='0'></a> ");
          document.write("<a href=javascript:cool()><img src='$imagesdir/cool.gif' align=bottom alt='$txt{'295'}' border='0'></a> ");
          document.write("<a href=javascript:huh()><img src='$imagesdir/huh.gif' align=bottom alt='$txt{'296'}' border='0'></a> ");
          document.write("<a href=javascript:rolleyes()><img src='$imagesdir/rolleyes.gif' align=bottom alt='$txt{'450'}' border='0'></a> ");
          document.write("<a href=javascript:tongue()><img src='$imagesdir/tongue.gif' align=bottom alt='$txt{'451'}' border='0'></a> ");
          document.write("<a href=javascript:embarassed()><img src='$imagesdir/embarassed.gif' align=bottom alt='$txt{'526'}' border='0'></a> ");
          document.write("<a href=javascript:lipsrsealed()><img src='$imagesdir/lipsrsealed.gif' align=bottom alt='$txt{'527'}' border='0'></a> ");
          document.write("<a href=javascript:undecided()><img src='$imagesdir/undecided.gif' align=bottom alt='$txt{'528'}' border='0'></a> ");
          document.write("<a href=javascript:kiss()><img src='$imagesdir/kiss.gif' align=bottom alt='$txt{'529'}' border='0'></a> ");
          document.write("<a href=javascript:cry()><img src='$imagesdir/cry.gif' align=bottom alt='$txt{'530'}' border='0'></a> ");
        }
        else { document.write("<font size='1'>$txt{'215'}</font>"); }
        //-->
        </script>
~;
}
#### end smilie
	print "</form>\n";
#### smilie
# print qq~
# <script language="JavaScript"> <!--
#   document.postmodify.says.focus();
# //--> </script>
# ~;
#### end smilie
	print "</font></font></body></html>\n";
}
#########################################
# Display info at top of Chatroom window

sub return_up {
	if ($userlevel >= $level_towho){$levelname="User";}
	if ($userlevel >= $level_kick){$levelname="Admin";}
	print "<html><head><title>Data</title>\n";
	print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;CHARSET=win\">\n";
	print "<STYLE TYPE=\"text/css\">\n";
	print "<!--\n";
	print "BODY	{font-size: 9pt;}\n";
	print "-->\n";
	print "</STYLE>\n";
	print "</head>\n";
	print "<body bgcolor=$fastback text=$saysword>\n";
	print "<center><font face=Arial>\n";
	print "[ $chadmtxt{'30'} $nyear, $nmon, $nday ] ";
	print "[ $chadmtxt{'29'} $nhour : $nmin ] \n";
	print "[ $chadmtxt{'26'} $user_ip ] \n";
	print "[ $chadmtxt{'27'} $userlevel ] [ $chadmtxt{'28'} $levelname ]\n";
	print "</font></center>\n";
	print "</body></html>\n";
}
#########################################
# Reads online.txt file and displays who is currently chatting
sub return_online {
	$return_online_subject = $_[0];
	fopen(ONLINE,"$onlinefile") || die $!;
	@online = <ONLINE>;
	fclose(ONLINE);

### add sound

# Initialize variables and get current number of users currently on chat
	my $soundflag = 'dontplay';
	my $leftflag = 0;
	my %soundusers;
	my $onlinecount = @online;

# Open chatcount file and put users and last usercount for each user in hash
	$chatcountfile = qq~$vardir/ChatCount.txt~;
	fopen(FILE, $chatcountfile);
	while ($strline=<FILE>) {
		chop($strline);
		@line = split(/\|/,$strline);
		my($index) = $line[0];
		$soundusers{$index} = $line[1];
	}
	fclose(FILE);

### end sound
	@online = sort @online;
	#this chunk is called when we want to display the list of people online in top right hand frame
	if ($return_online_subject eq "online") { 
		print "<html><head><title>Users Online</title>\n";
		print "<STYLE TYPE=\"text/css\">\n";
		print "<!--\n";
		print "body	{font-size: 9pt;}\n";
		print "td	{font-size: 9pt;}\n";
		print "a:link,a:visited {color: $link; text-decoration: none; }\n";
		print "a:hover {color: $link; text-decoration: overline underline; }\n";
		print "-->\n";
		print "</STYLE>\n";
		print "<META HTTP-EQUIV=REFRESH CONTENT=\"$reload_double; URL=$cgiurl\&job=online$userinfo\"></head>\n"; 
		print "<body bgcolor=$onlineback text=$onlineword>\n";
		print "<font face=Arial, Helvetica, sans-serif>\n";
		print "<font size=1>\n";
		print "<table border=0 width=100%>\n<tr><td align=center>$chadmtxt{'31'}</td></tr>\n";
	}
# This chunk is called when we want to show the "kickout" page
	elsif ($return_online_subject eq "kickout") {
		print "<html><head><title>Kick Program</title>\n";
		print "<META HTTP-EQUIV=REFRESH CONTENT=\"$reload_double;URL=$cgiurl\&job=setkick$userinfo\"></head>\n";
		print "<body bgcolor=$saysback><br><p><center>\n";
		print "<form method=POST action=\"$cgiurl\&job=kickout$userinfo\" target=\"one\" onsubmit=\"self.status='Data Sent'; return true;\">\n";
		print "<table border=0 width=80%>\n";
		print qq~<tr><td align=center><font size="1" face=Arial, Helvetica, sans-serif>$chadmtxt{'80'}</font></td><td align=center><font size="1" face=Arial, Helvetica, sans-serif>$txt{'68'}</font></td><td align=center><font size="1" face=Arial, Helvetica, sans-serif>$chadmtxt{'81'}</font></td><td align=center><font size="1" face=Arial, Helvetica, sans-serif>$chadmtxt{'82'}</font></td></tr>\n~; 
	}

	$lastcheck = "";
	foreach $online_line (@online) {
		($mark,$chkusername,$chkuserip,$chkuserdisplayname,$chkuserlevel,$chktime,$chksec,$chkkickout,$chkkickoutway,$markend,$last)=split(//,$online_line);
		if (($mark eq "online") && ($markend eq "end")) {
 			if (($lastcheck ne "$chkusername") && (!(($return_online_subject eq "online") && ($userlevel<$level_kick) && ($chkkickout eq "kickouted")))) {
				if (($return_online_subject eq "kickout") && ($userlevel>=$level_kick)) {
					print "<tr><td align=center>";
					if ($chkuserlevel<$level_kick) {
						print qq~<input type=radio name="kickoutuser" value="$chkusername">~;
					}
					else {
						print "<font size=1 face=Arial, Helvetica, sans-serif>$txt{'470'}</font>";
					}
					print "</td>"; 
					print "<td align=center><font size=1 face=Arial, Helvetica, sans-serif>$chkusername</font></td><td align=center><font size=1 face=Arial, Helvetica, sans-serif>$chkuserip</font></td>";
					if ($chkkickout eq "kickouted") {
						if ($chkkickoutway eq "level3"){$chkkickoutway="$chadmtxt{'33'}";}
						print "<td align=center><font size=1 face=Arial, Helvetica, sans-serif>$chkkickoutway</font></td>";
					}
					else {
						print "<td align=center><font size=1 face=Arial, Helvetica, sans-serif>$txt{'470'}</font></td>";
					}  
					print "</tr>\n";
				}
				else {
					if ($chkkickoutway ne "kickouted"){
						$user++;
						if ($chkusername eq 'Guest'){
							$whosonlineline = 'Guest';
						}
						else {
							$whosonlineline= "<a href=\"$scripturl?action=viewprofile;username=$chkusername\" target=\"_blank\">$chkuserdisplayname</a>";
						}
 						print "<tr><td align=\"center\">$whosonlineline";
						if ($userlevel>=$level_kick) {
							if ($chkuserlevel<$userlevel) {print "\&nbsp;($chkuserlevel)";}
							if ($chkuserlevel>=$userlevel) {print "\&nbsp;($chkuserlevel)";}
							if ($chkkickout eq "kickouted") {print "<font color=red>*</font>";}
						}
						print "</td></tr>\n";
					}
				}
			}
			$lastcheck = "$chkusername";
		}
	}
	if ($job eq "online"){
		print "<tr><td align=center>$chadmtxt{'62'} <font color=$sysmess>$user </font> $chadmtxt{'63'}</td></tr>\n";

### add sound

# test last usercount for current user against current count and set soundflag 

		if ( $soundusers{$username} < $onlinecount ) { $soundflag = 'play'; }
# print sound
		if ( $soundflag eq 'play' && $chatpopup == 1 ) {
			print qq~<body onLoad="alert('$chadmtxt{'83'}')"></body>~;
		}
# set new usercount to current user count
		$soundusers{$username} = $onlinecount;

# write hash back to chatcount file

		fopen(FILE, ">$chatcountfile");
		while ( ($index2,$soundcount) = each(%soundusers) ) {
			print FILE qq~$index2|$soundcount\n~;
		}
		fclose(FILE);
### end sound
		print "</table>\n";
		print "</font></font>\n";
		}
	if (($return_online_subject eq "kickout") && ($userlevel>=$level_kick)) {
		print "</table>\n";
		print "<hr size=-1 width=80%>\n";
		print qq~<font size=1 face=Arial, Helvetica, sans-serif>$chadmtxt{'32'}</font>~;
		print qq~<INPUT name="kickoutway" type=HIDDEN value="level3">~;
		print "<br><hr size=-1 width=40%><input type=submit value=\"Kick\"><input type=reset value=\"Reset\">\n";
		print "</form>\n";
	}
	print "</body></html>\n";
}

#########################################
# Display menu in lower righthand corner of Chatroom
sub return_func {
	print "<html><head><title>func</title></head>\n";
	print "<style type=\"text/css\">\n";
	print "<!--\n";
	print "A:link        {text-decoration: none; color: $link;}\n";
	print "A:visited     {text-decoration: none; color: $link;}\n";
	print "A:hover       {color: $link; text-decoration: underline overline}\n";
	print "BODY          {font-family: Verdana}\n";
	print "-->\n";
	print "</style>\n";
	print "</head>\n";
	print "<body bgcolor=$funcback text=$funcword>\n";
###
#	print qq~<font size=1><a href="$scripturl" target="_blank">$txt{'img8'}</a><br>\n~;
#	print "<a href=\"$cgiurl\&job=look$userinfo\" target=\"one\">$txt{'img1'}</a><br>\n";
	print "<font size=1><a href=\"$cgiurl\&job=look$userinfo\" target=\"one\">$txt{'img1'}</a><br>\n";
###
	print "<a href=\"$cgiurl\&job=online$userinfo\" target=\"three\">$txt{'img2'}</a><br>\n";
	print "<a href=\"$cgiurl\&job=settype$userinfo\" target=\"two\">$txt{'img7'}</a><br>\n";
	print "<a href=\"$cgiurl\&job=tell$userinfo\" target=\"one\">$txt{'img3'}</a><br>\n";
	if ($userlevel>=$level_cls){
		print "<a href=\"$cgiurl\&job=typecls$userinfo\" target=\"one\">$txt{'img4'}</a><br>\n";
	}
	if ($userlevel>=$level_kick){
		print "<a href=\"$cgiurl\&job=setkick$userinfo\" target=\"one\">$txt{'img5'}</a><br>\n";
	}
	print "<a href=\"$cgiurl\&job=logout$userinfo\&logouturl=$logouturl\" target=\"_top\">$txt{'img6'}</a><br>\n";
	print "</font></body></html>\n";
}
#########################################
# Setup various frames within Chatroom window
sub return_whole {
	print "<html><head><title>$title</title>\n";
	print "<SCRIPT LANGUAGE=\"JavaScript\">\n"; 
	print "var exit=true;\n";
	print "function leave() {\n"; 
	print "if (exit)\n"; 
	print "window.open('$cgiurl\&job=logout$userinfo\&logouturl=$logouturl','','toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,height=450,width=675');\n"; 
	print "}\n"; 
	print "</script>\n";	
	print "</head>\n";
	print "<frameset onUnload='leave()' cols=\"525,150\" border=0  frameborder=0 framespacing=0>\n";
	if ($show_top eq '1') {
		$rows="20,*,70";}
	else {
		$rows="*,100";}
	print "<frameset rows=\"$rows\" border=0 frameborder=0 framespacing=0>\n";
	if ($show_top eq '1') {
		print "<frame src=\"$cgiurl&job=setup$userinfo\" name=\"up\" noresize marginwidth=0>\n";
		}
	print "<frame src=\"$cgiurl\&job=tell$userinfo\" name=\"one\" noresize marginwidth=0 nowrap>\n";
	print "<frame src=\"$cgiurl\&job=settype$userinfo\" name=\"two\" noresize marginwidth=0 scrolling=\"no\" nowrap>\n";
	print "</frameset>\n";	
	print "<frameset rows=\"*,140\" border=0 frameborder=0 framespacing=0>\n";
	print "<frame src=\"$cgiurl\&job=online$userinfo\" name=\"three\" noresize marginwidth=0>\n";
	print "<frame src=\"$cgiurl\&job=setfunc$userinfo\" name=\"five\" marginwidth=0>\n";
	print "</frameset>\n";
	print "</frameset>\n";
	print "</head></html>\n";  
}
#########################################
# Display info screen at startup and if "info" clicked
sub return_tell {
	print "<html><head><title>$title</title>\n";
	print "<META HTTP-EQUIV=REFRESH CONTENT=\"5;URL=$cgiurl\&job=look$userinfo\">\n";
	print "<STYLE TYPE=\"text/css\">\n";
	print "<!--\n";
	print "	body	{font-size: 9pt;}\n";
	print "	td	{font-size: 9pt;}\n";
	print "-->\n";
	print "</STYLE>\n";
	print "</head>\n";
	print "<body bgcolor=$saysback text=$saysword>\n";
	print "<div align=\"center\">";
	print "<font face=Verdana, Arial, Helvetica, sans-serif size=+1>$mbname $chadmtxt{'11'}</font>\n";
	print "</div>";
	print qq~<font face=Arial, Helvetica, sans-serif size=2>$chatinfo</font>\n~;
	print "<center><a href=\"$cgiurl\&job=look$userinfo\" target=\"one\"><font face=Arial, Helvetica, sans-serif size=2>$chadmtxt{'36'}</font></a></center>";
	print "</body></html>\n";
}
#########################################
# Call close.htm to close out chatroom windows
sub return_logout {
	print "<html><head><title>$title</title>\n";
	print "<META HTTP-EQUIV=REFRESH CONTENT=\"0;URL=$logouturl\"></head>\n";
	print "<body>\n";
	print "</body></html>\n";  
}
#########################################
# Assign returned data to proper variables, check for errors
sub set_var {
	if ($INFO{'job'}) {
		$job = "$INFO{'job'}";
		&chkempty($job,"$chadmtxt{'76'}");
	}
	else {
		&error("$chadmtxt{'76'} $chadmtxt{'77'} $yyCookies{$cookieusername}"); 
	}

	if ($FORM{'towhoway'}) {
		$towhoway = "$FORM{'towhoway'}";
		$towhoway =~ s/\n//g;
	}
	if ($FORM{'towho'}) {
		$towho = "$FORM{'towho'}";
		$towho =~ s/\n//g;
	}
	if ($FORM{'wordcolor'}) {
		$wordcolor = "$FORM{'wordcolor'}";
		$wordcolor =~ s/\n//g;
	}
	if ($FORM{'says'}) {
		$says = "$FORM{'says'}";
		$says =~ s/\n//g;
		$says =~ s///g;
		&chkempty($says,"$chadmtxt{'78'}"); 
	}
	else {
		if ($job eq "says") {
			&error("$chadmtxt{'78'}");
		}
	}
#	if ($FORM{'addsays'}) {
#		$addsays = "$FORM{'addsays'}";
#		$addsays =~ s/\n//g;
#		$addsays =~ s///g;
#	}
	if ($FORM{'kickoutuser'}) {
		$kickoutuser = "$FORM{'kickoutuser'}";
		$kickoutuser =~ s/\n//g;
	}
	if ($FORM{'kickoutway'}) {
		$kickoutway = "$FORM{'kickoutway'}";
		$kickoutway =~ s/\n//g;
	}
	if ($FORM{'logouturl'}) {
		$logouturl = "$FORM{'logouturl'}";
		$logouturl =~ s/\n//g;
	}
#	if ($FORM{'foururl'}) {
#		$foururl = "$FORM{'foururl'}";
#		$foururl =~ s/\n//g;
#	}
#	if ($FORM{'fourscrolling'}) {
#		$fourscrolling = "$FORM{'fourscrolling'}";
#		$fourscrolling =~ s/\n//g;
#	}
	($nsec,$nmin,$nhour,$nday,$nmon,$nyear,$wday,$yday,$isdst) = localtime(time + (3600*$timeoffset));                                        
	$nyear = $nyear - 100 + 2000;
	if ($nsec<10) {$nsec="0$nsec";}
	if ($nmin<10) {$nmin="0$nmin";}
	if ($nhour<10) {$nhour="0$nhour";}
	$nmon=$nmon+1; 
	if ($nmon<10) {$nmon="0$nmon";}
	if ($nday<10) {$nday="0$nday";}
	$normal_time  ="$nhour\:$nmin\:$nsec";
	$now_sec      =$nsec + ($nmin*60) + ($nhour*60*60) + ($nday*24*60*60);
	$cut1_sec     =$now_sec-($reload*4.2);
	$cut2_sec     =$now_sec+($reload*4.2);
	$cut3_sec     =$now_sec-($kicktime);
	$cut4_sec     =$now_sec+($kicktime);
	$reload_double=$reload*2;
	$userinfo     ="";
}
#########################################
# Check to see if chatroom text box was empty when <enter> pressed
sub chkempty {
	$chkval = $_[0];
	$chkerr = $_[1];
	$chkval =~ s/ //g;
	$chkval =~ s/<br>//g;
	$chkval =~ s/\n//g;
	if ($chkval eq "") { 
		&error($chkerr);
	}
}
#########################################
# Wipe Chat
sub return_cls {
	fopen(MAIN,">$messfile");
	print MAIN "";
	fclose(MAIN);
}
#########################################
# Error handling
sub error {
	$error_subject = $_[0];
	print "Content-type: text/html;CHARSET=$yycharset\n";
	print "Pragma:no-cache\n\n";
	print "<html><head><title>ERROR</title></head>\n";
	print "<body>\n";
	print "<script type=\"text/javascript\" language=\"JavaScript\">\n";
	print "if (top.location != location) {\n";
	print "    top.location.href = document.location.href ;\n";
	print "  }\n";
	print "</script>";
	print "<center><h1>\n";
	print "$chadmtxt{'79'} $error_subject\n";
	print "</h1></center></body></html>\n";
}
1;

